/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.jersey;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.spi.container.ResourceMethodDispatchProvider;
import com.sun.jersey.spi.dispatch.RequestDispatcher;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.annotation.ExceptionMetered;
import com.yammer.metrics.annotation.Metered;
import com.yammer.metrics.annotation.Timed;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;

class InstrumentedResourceMethodDispatchProvider
implements ResourceMethodDispatchProvider {
    private final ResourceMethodDispatchProvider provider;

    private static <E extends Exception> void rethrow(Exception e) throws E {
        throw e;
    }

    public InstrumentedResourceMethodDispatchProvider(ResourceMethodDispatchProvider provider) {
        this.provider = provider;
    }

    public RequestDispatcher create(AbstractResourceMethod method) {
        Meter meter;
        MetricName metricName;
        String name;
        String type;
        String group;
        Class klass;
        Timed annotation;
        RequestDispatcher dispatcher = this.provider.create(method);
        if (dispatcher == null) {
            return null;
        }
        if (method.getMethod().isAnnotationPresent(Timed.class)) {
            annotation = method.getMethod().getAnnotation(Timed.class);
            klass = method.getDeclaringResource().getResourceClass();
            group = MetricName.chooseGroup((String)annotation.group(), (Class)klass);
            type = MetricName.chooseType((String)annotation.type(), (Class)klass);
            name = MetricName.chooseName((String)annotation.name(), (Method)method.getMethod());
            metricName = new MetricName(group, type, name);
            Timer timer = Metrics.newTimer((MetricName)metricName, (TimeUnit)(annotation.durationUnit() == null ? TimeUnit.MILLISECONDS : annotation.durationUnit()), (TimeUnit)(annotation.rateUnit() == null ? TimeUnit.SECONDS : annotation.rateUnit()));
            dispatcher = new TimedRequestDispatcher(dispatcher, timer);
        }
        if (method.getMethod().isAnnotationPresent(Metered.class)) {
            annotation = method.getMethod().getAnnotation(Metered.class);
            klass = method.getDeclaringResource().getResourceClass();
            group = MetricName.chooseGroup((String)annotation.group(), (Class)klass);
            type = MetricName.chooseType((String)annotation.type(), (Class)klass);
            name = MetricName.chooseName((String)annotation.name(), (Method)method.getMethod());
            metricName = new MetricName(group, type, name);
            meter = Metrics.newMeter((MetricName)metricName, (String)(annotation.eventType() == null ? "requests" : annotation.eventType()), (TimeUnit)(annotation.rateUnit() == null ? TimeUnit.SECONDS : annotation.rateUnit()));
            dispatcher = new MeteredRequestDispatcher(dispatcher, meter);
        }
        if (method.getMethod().isAnnotationPresent(ExceptionMetered.class)) {
            annotation = method.getMethod().getAnnotation(ExceptionMetered.class);
            klass = method.getDeclaringResource().getResourceClass();
            group = MetricName.chooseGroup((String)annotation.group(), (Class)klass);
            type = MetricName.chooseType((String)annotation.type(), (Class)klass);
            name = annotation.name() == null || annotation.name().equals("") ? method.getMethod().getName() + "Exceptions" : annotation.name();
            metricName = new MetricName(group, type, name);
            meter = Metrics.newMeter((MetricName)metricName, (String)(annotation.eventType() == null ? "requests" : annotation.eventType()), (TimeUnit)(annotation.rateUnit() == null ? TimeUnit.SECONDS : annotation.rateUnit()));
            dispatcher = new ExceptionMeteredRequestDispatcher(dispatcher, meter, annotation.cause());
        }
        return dispatcher;
    }

    private static class ExceptionMeteredRequestDispatcher
    implements RequestDispatcher {
        private final RequestDispatcher underlying;
        private final Meter meter;
        private final Class<? extends Throwable> exceptionClass;

        private ExceptionMeteredRequestDispatcher(RequestDispatcher underlying, Meter meter, Class<? extends Throwable> exceptionClass) {
            this.underlying = underlying;
            this.meter = meter;
            this.exceptionClass = exceptionClass;
        }

        public void dispatch(Object resource, HttpContext httpContext) {
            try {
                this.underlying.dispatch(resource, httpContext);
            }
            catch (Exception e) {
                if (this.exceptionClass.isAssignableFrom(e.getClass()) || e.getCause() != null && this.exceptionClass.isAssignableFrom(e.getCause().getClass())) {
                    this.meter.mark();
                }
                InstrumentedResourceMethodDispatchProvider.rethrow(e);
            }
        }
    }

    private static class MeteredRequestDispatcher
    implements RequestDispatcher {
        private final RequestDispatcher underlying;
        private final Meter meter;

        private MeteredRequestDispatcher(RequestDispatcher underlying, Meter meter) {
            this.underlying = underlying;
            this.meter = meter;
        }

        public void dispatch(Object resource, HttpContext httpContext) {
            this.meter.mark();
            this.underlying.dispatch(resource, httpContext);
        }
    }

    private static class TimedRequestDispatcher
    implements RequestDispatcher {
        private final RequestDispatcher underlying;
        private final Timer timer;

        private TimedRequestDispatcher(RequestDispatcher underlying, Timer timer) {
            this.underlying = underlying;
            this.timer = timer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatch(Object resource, HttpContext httpContext) {
            TimerContext context = this.timer.time();
            try {
                this.underlying.dispatch(resource, httpContext);
            }
            finally {
                context.stop();
            }
        }
    }
}

