/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxws.model;

public enum BindingType {
    SOAP_1_1("http://schemas.xmlsoap.org/wsdl/soap/http"),
    SOAP_1_2("http://www.w3.org/2003/05/soap/bindings/HTTP/"),
    HTTP("http://www.w3.org/2004/08/wsdl/http");

    private final String namespace;

    private BindingType(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isSoap11() {
        return "http://schemas.xmlsoap.org/wsdl/soap/http".equals(this.getNamespace());
    }

    public boolean isSoap12() {
        return "http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(this.getNamespace());
    }

    public boolean isHttp() {
        return "http://www.w3.org/2004/08/wsdl/http".equals(this.getNamespace());
    }

    public static BindingType fromNamespace(String namespace) {
        for (BindingType bindingType : BindingType.values()) {
            if (!bindingType.getNamespace().equals(namespace)) continue;
            return bindingType;
        }
        throw new IllegalArgumentException("Unsupported binding type: " + namespace);
    }
}

