/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.shared.internal;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.dependency.JsModule;
import java.io.Serializable;
import java.util.Objects;

@JsModule(value="./disableOnClickFunctions.js")
public class DisableOnClickController<C extends Component>
implements Serializable {
    private final C component;
    private boolean disableOnClick = false;

    public DisableOnClickController(C component) {
        this.component = (Component)Objects.requireNonNull(component);
        ComponentUtil.addListener(component, ClickEvent.class, (ComponentEventListener & Serializable)event -> {
            if (this.isDisableOnClick()) {
                ((HasEnabled)component).setEnabled(false);
            }
        });
    }

    public void setDisableOnClick(boolean disableOnClick) {
        this.disableOnClick = disableOnClick;
        if (disableOnClick) {
            this.component.getElement().setAttribute("disableonclick", "true");
        } else {
            this.component.getElement().removeAttribute("disableonclick");
        }
    }

    public boolean isDisableOnClick() {
        return this.disableOnClick;
    }

    public void onSetEnabled(boolean enabled) {
        this.component.getElement().executeJs("this.disabled = $0", new Object[]{!enabled});
    }
}

