/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts.model;

import com.vaadin.flow.component.charts.model.AbstractSeries;

public class HeatSeries
extends AbstractSeries {
    Number[][] data;

    public HeatSeries() {
    }

    public HeatSeries(String name) {
        this.setName(name);
    }

    public HeatSeries(String name, Number[] ... values) {
        this(name);
        this.setData(values);
    }

    public void setData(Number[] ... values) {
        this.clear();
        this.addHeatData(values);
    }

    public Number[][] getData() {
        return this.data;
    }

    public void addHeatPoint(int x, int y, Number heatScore) {
        this.addHeatData(new Number[][]{{x, y, heatScore}});
    }

    public void clear() {
        this.data = null;
    }

    private void addHeatData(Number[][] values) {
        if (values == null || values.length == 0) {
            return;
        }
        Number[] firstItem = values[0];
        if (firstItem.length == 3) {
            if (this.data == null) {
                this.data = values;
            } else {
                Number[][] newData = new Number[this.data.length + values.length][3];
                System.arraycopy(this.data, 0, newData, 0, this.data.length);
                System.arraycopy(values, 0, newData, this.data.length, values.length);
                this.data = newData;
            }
        } else {
            throw new IllegalArgumentException("The data should be x,y,heatScore triplets");
        }
    }
}

