/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.router.internal.RouteFormat;
import java.io.Serializable;
import java.util.Optional;

public class ParameterInfo
implements Serializable {
    private final String name;
    private final String template;
    private final boolean optional;
    private final boolean varargs;
    private final String regex;

    public ParameterInfo(String template) {
        int regexStartIndex;
        this.template = template;
        if (!RouteFormat.isParameter(template)) {
            throw new IllegalArgumentException("The given string is not a parameter template.");
        }
        this.optional = RouteFormat.isOptionalParameter(template);
        if (this.optional) {
            template = template.replaceFirst("\\?", "");
        }
        this.varargs = RouteFormat.isVarargsParameter(template);
        if (this.varargs) {
            template = template.replaceFirst("\\*", "");
        }
        if ((regexStartIndex = (template = template.substring(1)).indexOf(40)) != -1) {
            this.name = template.substring(0, regexStartIndex);
            this.regex = template.substring(regexStartIndex + 1, template.length() - 1);
        } else {
            this.name = template;
            this.regex = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getTemplate() {
        return this.template;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isVarargs() {
        return this.varargs;
    }

    public Optional<String> getRegex() {
        return Optional.ofNullable(this.regex);
    }
}

