/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.converter;

import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializableSupplier;
import java.io.Serializable;

public interface Converter<PRESENTATION, MODEL>
extends Serializable {
    public Result<MODEL> convertToModel(PRESENTATION var1, ValueContext var2);

    public PRESENTATION convertToPresentation(MODEL var1, ValueContext var2);

    public static <T> Converter<T, T> identity() {
        return Converter.from((SerializableFunction & Serializable)t -> Result.ok(t), (SerializableFunction & Serializable)t -> t);
    }

    public static <P, M> Converter<P, M> from(SerializableFunction<P, M> toModel, SerializableFunction<M, P> toPresentation, SerializableFunction<Exception, String> onError) {
        return Converter.from((SerializableFunction & Serializable)val -> Result.of((SerializableSupplier & Serializable)() -> toModel.apply(val), onError), toPresentation);
    }

    public static <P, M> Converter<P, M> from(final SerializableFunction<P, Result<M>> toModel, final SerializableFunction<M, P> toPresentation) {
        return new Converter<P, M>(){

            @Override
            public Result<M> convertToModel(P value, ValueContext context) {
                return (Result)toModel.apply(value);
            }

            @Override
            public P convertToPresentation(M value, ValueContext context) {
                return toPresentation.apply(value);
            }
        };
    }

    default public <T> Converter<PRESENTATION, T> chain(final Converter<MODEL, T> other) {
        return new Converter<PRESENTATION, T>(){

            @Override
            public Result<T> convertToModel(PRESENTATION value, ValueContext context) {
                Result model = Converter.this.convertToModel(value, context);
                return model.flatMap((SerializableFunction & Serializable)v -> other.convertToModel(v, context));
            }

            @Override
            public PRESENTATION convertToPresentation(T value, ValueContext context) {
                Object model = other.convertToPresentation(value, context);
                return Converter.this.convertToPresentation(model, context);
            }
        };
    }
}

