/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.vaadin.base.devserver.FileWatcher;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.javarewriter.ComponentTypeAndSourceLocation;
import com.vaadin.copilot.javarewriter.exception.ComponentInfoNotFoundException;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.DevModeHandlerManager;
import com.vaadin.flow.server.Command;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceSyncChecker {
    private static final String JAVA_FILE_EXTENSION = ".java";
    private final Set<File> updatedAtLeastOnce = new HashSet<File>();
    private final Set<String> notSyncIssuesStacktrace = new HashSet<String>();
    private final ProjectManager projectManager;
    private final SerializableConsumer<File> sourceClassChangeListener = (SerializableConsumer & Serializable)sourceFile -> {
        if (sourceFile.isFile() && sourceFile.getAbsolutePath().endsWith(JAVA_FILE_EXTENSION)) {
            this.updatedAtLeastOnce.add((File)sourceFile);
        }
    };
    private final List<FileWatcher> sourceFileWatchers = new ArrayList<FileWatcher>();

    public SourceSyncChecker(ProjectManager projectManager, DevModeHandlerManager devModeHandler) {
        this.projectManager = projectManager;
        this.startSourceFileWatchers(devModeHandler);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(SourceSyncChecker.class);
    }

    private void startSourceFileWatchers(DevModeHandlerManager devModeHandler) {
        List<FileWatcher> watchers = this.projectManager.getSourceFolders().stream().map(this::startSourceFileWatcher).filter(Objects::nonNull).toList();
        this.sourceFileWatchers.addAll(watchers);
        this.registerWatcherShutdownCommand(devModeHandler);
    }

    private FileWatcher startSourceFileWatcher(Path sourcePath) {
        try {
            File sourceFolder = sourcePath.toFile();
            FileWatcher sourceFileWatcher = new FileWatcher(this.sourceClassChangeListener, sourceFolder);
            sourceFileWatcher.start();
            SourceSyncChecker.getLogger().debug("Started watching {}", (Object)sourceFolder);
            return sourceFileWatcher;
        }
        catch (IOException e) {
            SourceSyncChecker.getLogger().error("Could not start file watched for source classes", (Throwable)e);
            return null;
        }
    }

    private void registerWatcherShutdownCommand(DevModeHandlerManager devModeHandlerManager) {
        devModeHandlerManager.registerShutdownCommand((Command & Serializable)() -> {
            for (FileWatcher sourceFileWatcher : this.sourceFileWatchers) {
                try {
                    sourceFileWatcher.stop();
                }
                catch (IOException e) {
                    SourceSyncChecker.getLogger().error("Could not stop file watcher for source classes", (Throwable)e);
                }
            }
            this.sourceFileWatchers.clear();
        });
    }

    public boolean maybeOutOfSync(ComponentInfoNotFoundException exception) {
        if (this.notSyncIssuesStacktrace.contains(ExceptionUtils.getStackTrace((Throwable)exception))) {
            return false;
        }
        ComponentTypeAndSourceLocation componentTypeAndSourceLocation = exception.getComponentTypeAndSourceLocation();
        File sourceFile = componentTypeAndSourceLocation.javaFile();
        if (!this.updatedAtLeastOnce.contains(sourceFile)) {
            this.notSyncIssuesStacktrace.add(ExceptionUtils.getStackTrace((Throwable)exception));
            return false;
        }
        return this.updatedAtLeastOnce.contains(sourceFile);
    }

    List<FileWatcher> getSourceFileWatchers() {
        return this.sourceFileWatchers;
    }
}

