/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.SSLMessages;
import com.unboundid.util.ssl.WrapperKeyManager;
import java.security.KeyStore;
import java.security.KeyStoreException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PKCS11KeyManager
extends WrapperKeyManager {
    private static final String PKCS11_KEY_STORE_TYPE = "PKCS11";

    public PKCS11KeyManager(char[] keyStorePIN, String certificateAlias) throws KeyStoreException {
        super(PKCS11KeyManager.getKeyManagers(keyStorePIN), certificateAlias);
    }

    private static KeyManager[] getKeyManagers(char[] keyStorePIN) throws KeyStoreException {
        KeyStore ks = KeyStore.getInstance(PKCS11_KEY_STORE_TYPE);
        try {
            ks.load(null, keyStorePIN);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new KeyStoreException(SSLMessages.ERR_PKCS11_CANNOT_ACCESS.get(StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            factory.init(ks, keyStorePIN);
            return factory.getKeyManagers();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new KeyStoreException(SSLMessages.ERR_PKCS11_CANNOT_GET_KEY_MANAGERS.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }
}

