/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.util.Debug;
import com.unboundid.util.Mutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicReference;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class SubtreeDeleterSearchResultListener
implements SearchResultListener {
    private static final long serialVersionUID = -6828026542462924962L;
    private final AtomicReference<LDAPException> firstException;
    private final DN searchBaseDN;
    private final Filter searchFilter;
    private final SortedSet<DN> dnSet;

    SubtreeDeleterSearchResultListener(DN searchBaseDN, Filter searchFilter, SortedSet<DN> dnSet) {
        this.searchBaseDN = searchBaseDN;
        this.searchFilter = searchFilter;
        this.dnSet = dnSet;
        this.firstException = new AtomicReference();
    }

    LDAPException getFirstException() {
        return this.firstException.get();
    }

    @Override
    public void searchEntryReturned(SearchResultEntry searchEntry) {
        try {
            this.dnSet.add(searchEntry.getParsedDN());
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            this.firstException.compareAndSet(null, e);
        }
    }

    @Override
    public void searchReferenceReturned(SearchResultReference searchReference) {
        if (this.firstException.get() == null) {
            Object[] referralURLs = searchReference.getReferralURLs();
            Object urlsString = referralURLs.length == 1 ? referralURLs[0] : Arrays.toString(referralURLs);
            this.firstException.compareAndSet(null, new LDAPException(ResultCode.REFERRAL, UtilityMessages.ERR_SUBTREE_DELETER_SEARCH_LISTENER_REFERENCE_RETURNED.get(urlsString, String.valueOf(this.searchBaseDN), String.valueOf(this.searchFilter))));
        }
    }
}

