/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPModify;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.ldif.LDIFModifyChangeRecord;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.Debug;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.List;
import java.util.Set;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
final class LDAPModifySearchListener
implements SearchResultListener {
    private static final long serialVersionUID = -583082242208798146L;
    private final Filter searchFilter;
    private final FixedRateBarrier rateLimiter;
    private final LDAPConnectionPool connectionPool;
    private final LDAPModify ldapModify;
    private final LDIFModifyChangeRecord sourceChangeRecord;
    private final LDIFWriter rejectWriter;
    private final List<Control> modifyControls;
    private volatile ResultCode resultCode;
    private final Set<DN> processedEntryDNs;

    LDAPModifySearchListener(LDAPModify ldapModify, LDIFModifyChangeRecord sourceChangeRecord, Filter searchFilter, List<Control> modifyControls, LDAPConnectionPool connectionPool, FixedRateBarrier rateLimiter, LDIFWriter rejectWriter, Set<DN> processedEntryDNs) {
        this.ldapModify = ldapModify;
        this.sourceChangeRecord = sourceChangeRecord;
        this.searchFilter = searchFilter;
        this.modifyControls = modifyControls;
        this.connectionPool = connectionPool;
        this.rateLimiter = rateLimiter;
        this.rejectWriter = rejectWriter;
        this.processedEntryDNs = processedEntryDNs;
        this.resultCode = ResultCode.SUCCESS;
    }

    ResultCode getResultCode() {
        return this.resultCode;
    }

    @Override
    public void searchEntryReturned(SearchResultEntry searchEntry) {
        DN parsedDN;
        block8: {
            parsedDN = null;
            try {
                parsedDN = searchEntry.getParsedDN();
                if (this.processedEntryDNs.contains(parsedDN)) {
                    return;
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            if (this.rateLimiter != null) {
                this.rateLimiter.await();
            }
            LDIFModifyChangeRecord changeRecordFromSearchEntry = new LDIFModifyChangeRecord(searchEntry.getDN(), this.sourceChangeRecord.getModifications(), this.sourceChangeRecord.getControls());
            try {
                ResultCode rc = this.ldapModify.doModify(changeRecordFromSearchEntry, this.modifyControls, this.connectionPool, null, this.rejectWriter);
                if (rc != ResultCode.SUCCESS && (this.resultCode == ResultCode.SUCCESS || this.resultCode == ResultCode.NO_OPERATION)) {
                    this.resultCode = rc;
                }
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                if (this.resultCode != ResultCode.SUCCESS && this.resultCode != ResultCode.NO_OPERATION) break block8;
                this.resultCode = le.getResultCode();
            }
        }
        if (parsedDN != null) {
            this.processedEntryDNs.add(parsedDN);
        }
    }

    @Override
    public void searchReferenceReturned(SearchResultReference searchReference) {
        StringBuilder urls = new StringBuilder();
        for (String url : searchReference.getReferralURLs()) {
            if (urls.length() > 0) {
                urls.append(", ");
            }
            urls.append(url);
        }
        String comment = ToolMessages.ERR_LDAPMODIFY_SEARCH_LISTENER_REFERRAL.get(this.sourceChangeRecord.getDN(), String.valueOf(this.searchFilter), urls.toString());
        this.ldapModify.writeRejectedChange(this.rejectWriter, comment, this.sourceChangeRecord);
    }
}

