/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ClientConnectionMonitorEntry
extends MonitorEntry {
    static final String CLIENT_CONNECTION_MONITOR_OC = "ds-client-connection-monitor-entry";
    private static final String ATTR_CONNECTION = "connection";
    private static final long serialVersionUID = -1705824766273147598L;
    private final List<String> connections = this.getStrings("connection");

    public ClientConnectionMonitorEntry(Entry entry) {
        super(entry);
    }

    public List<String> getConnections() {
        return this.connections;
    }

    @Override
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_CLIENT_CONNECTION_MONITOR_DISPNAME.get();
    }

    @Override
    public String getMonitorDescription() {
        return MonitorMessages.INFO_CLIENT_CONNECTION_MONITOR_DESC.get();
    }

    @Override
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(StaticUtils.computeMapCapacity(1));
        if (!this.connections.isEmpty()) {
            ClientConnectionMonitorEntry.addMonitorAttribute(attrs, ATTR_CONNECTION, MonitorMessages.INFO_CLIENT_CONNECTION_DISPNAME_CONNECTION.get(), MonitorMessages.INFO_CLIENT_CONNECTION_DESC_CONNECTION.get(), this.connections);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

