/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.PostConnectProcessor;
import com.unboundid.ldap.sdk.SRVRecord;
import com.unboundid.ldap.sdk.SRVRecordSet;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.net.SocketFactory;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DNSSRVRecordServerSet
extends ServerSet {
    private static final String DEFAULT_RECORD_NAME = "_ldap._tcp";
    private static final long DEFAULT_TTL_MILLIS = 3600000L;
    private static final String DEFAULT_DNS_PROVIDER_URL = "dns:";
    private final BindRequest bindRequest;
    private final Hashtable<String, String> jndiProperties;
    private final LDAPConnectionOptions connectionOptions;
    private final long ttlMillis;
    private final PostConnectProcessor postConnectProcessor;
    private final SocketFactory socketFactory;
    private volatile SRVRecordSet recordSet;
    private final String recordName;
    private final String providerURL;

    public DNSSRVRecordServerSet(String recordName) {
        this(recordName, null, 3600000L, null, null);
    }

    public DNSSRVRecordServerSet(String recordName, String providerURL, long ttlMillis, SocketFactory socketFactory, LDAPConnectionOptions connectionOptions) {
        this(recordName, providerURL, null, ttlMillis, socketFactory, connectionOptions);
    }

    public DNSSRVRecordServerSet(String recordName, String providerURL, Properties jndiProperties, long ttlMillis, SocketFactory socketFactory, LDAPConnectionOptions connectionOptions) {
        this(recordName, providerURL, jndiProperties, ttlMillis, socketFactory, connectionOptions, null, null);
    }

    public DNSSRVRecordServerSet(String recordName, String providerURL, Properties jndiProperties, long ttlMillis, SocketFactory socketFactory, LDAPConnectionOptions connectionOptions, BindRequest bindRequest, PostConnectProcessor postConnectProcessor) {
        this.socketFactory = socketFactory;
        this.connectionOptions = connectionOptions;
        this.bindRequest = bindRequest;
        this.postConnectProcessor = postConnectProcessor;
        this.recordSet = null;
        this.recordName = recordName == null ? DEFAULT_RECORD_NAME : recordName;
        this.providerURL = providerURL == null ? DEFAULT_DNS_PROVIDER_URL : providerURL;
        this.jndiProperties = new Hashtable(10);
        if (jndiProperties != null) {
            for (Map.Entry<Object, Object> e : jndiProperties.entrySet()) {
                this.jndiProperties.put(String.valueOf(e.getKey()), String.valueOf(e.getValue()));
            }
        }
        if (!this.jndiProperties.containsKey("java.naming.factory.initial")) {
            this.jndiProperties.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        }
        if (!this.jndiProperties.containsKey("java.naming.provider.url")) {
            this.jndiProperties.put("java.naming.provider.url", this.providerURL);
        }
        this.ttlMillis = ttlMillis <= 0L ? 3600000L : ttlMillis;
    }

    public String getRecordName() {
        return this.recordName;
    }

    public String getProviderURL() {
        return this.providerURL;
    }

    public Map<String, String> getJNDIProperties() {
        return Collections.unmodifiableMap(this.jndiProperties);
    }

    public long getTTLMillis() {
        return this.ttlMillis;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public LDAPConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    @Override
    public boolean includesAuthentication() {
        return this.bindRequest != null;
    }

    @Override
    public boolean includesPostConnectProcessing() {
        return this.postConnectProcessor != null;
    }

    @Override
    public LDAPConnection getConnection() throws LDAPException {
        return this.getConnection(null);
    }

    @Override
    public LDAPConnection getConnection(LDAPConnectionPoolHealthCheck healthCheck) throws LDAPException {
        block6: {
            if (this.recordSet == null || this.recordSet.isExpired()) {
                try {
                    this.recordSet = SRVRecordSet.getRecordSet(this.recordName, this.jndiProperties, this.ttlMillis);
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    if (this.recordSet != null) break block6;
                    throw le;
                }
            }
        }
        LDAPException firstException = null;
        for (SRVRecord r : this.recordSet.getOrderedRecords()) {
            try {
                LDAPConnection connection = new LDAPConnection(this.socketFactory, this.connectionOptions, r.getAddress(), r.getPort());
                DNSSRVRecordServerSet.doBindPostConnectAndHealthCheckProcessing(connection, this.bindRequest, this.postConnectProcessor, healthCheck);
                this.associateConnectionWithThisServerSet(connection);
                return connection;
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                if (firstException != null) continue;
                firstException = le;
            }
        }
        throw firstException;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("DNSSRVRecordServerSet(recordName='");
        buffer.append(this.recordName);
        buffer.append("', providerURL='");
        buffer.append(this.providerURL);
        buffer.append("', ttlMillis=");
        buffer.append(this.ttlMillis);
        if (this.socketFactory != null) {
            buffer.append(", socketFactoryClass='");
            buffer.append(this.socketFactory.getClass().getName());
            buffer.append('\'');
        }
        if (this.connectionOptions != null) {
            buffer.append(", connectionOptions");
            this.connectionOptions.toString(buffer);
        }
        buffer.append(", includesAuthentication=");
        buffer.append(this.bindRequest != null);
        buffer.append(", includesPostConnectProcessing=");
        buffer.append(this.postConnectProcessor != null);
        buffer.append(')');
    }
}

