/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.LDAPListenerConfig;
import com.unboundid.ldap.listener.LDAPListenerExceptionHandler;
import com.unboundid.ldap.listener.ListenerMessages;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.extensions.NoticeOfDisconnectionExtendedResult;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ServerSocketFactory;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class LDAPListener
extends Thread {
    private final AtomicBoolean stopRequested;
    private final AtomicLong nextConnectionID;
    private final AtomicReference<ServerSocket> serverSocket;
    private final AtomicReference<Thread> thread;
    private final ConcurrentHashMap<Long, LDAPListenerClientConnection> establishedConnections;
    private final CountDownLatch startLatch;
    private final LDAPListenerConfig config;

    public LDAPListener(LDAPListenerConfig config) {
        this.config = config.duplicate();
        this.stopRequested = new AtomicBoolean(false);
        this.nextConnectionID = new AtomicLong(0L);
        this.serverSocket = new AtomicReference<Object>(null);
        this.thread = new AtomicReference<Object>(null);
        this.startLatch = new CountDownLatch(1);
        this.establishedConnections = new ConcurrentHashMap(StaticUtils.computeMapCapacity(20));
        this.setName("LDAP Listener Thread (not listening");
    }

    public void startListening() throws IOException {
        ServerSocketFactory f = this.config.getServerSocketFactory();
        InetAddress a = this.config.getListenAddress();
        int p = this.config.getListenPort();
        if (a == null) {
            this.serverSocket.set(f.createServerSocket(this.config.getListenPort(), 128));
        } else {
            this.serverSocket.set(f.createServerSocket(this.config.getListenPort(), 128, a));
        }
        int receiveBufferSize = this.config.getReceiveBufferSize();
        if (receiveBufferSize > 0) {
            this.serverSocket.get().setReceiveBufferSize(receiveBufferSize);
        }
        this.setName("LDAP Listener Thread (listening on port " + this.serverSocket.get().getLocalPort() + ')');
        this.start();
        try {
            this.startLatch.await();
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @InternalUseOnly
    public void run() {
        block19: {
            LDAPListenerClientConnection c;
            Closeable s;
            this.thread.set(Thread.currentThread());
            LDAPListenerExceptionHandler exceptionHandler = this.config.getExceptionHandler();
            this.startLatch.countDown();
            while (!this.stopRequested.get()) {
                try {
                    s = this.serverSocket.get().accept();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    if (e instanceof SocketException && this.serverSocket.get().isClosed()) {
                        ServerSocket s2 = this.serverSocket.getAndSet(null);
                        if (s2 != null) {
                            try {
                                s2.close();
                            }
                            catch (Exception e2) {
                                Debug.debugException(e2);
                            }
                        }
                        this.serverSocket.set(null);
                        this.thread.set(null);
                        return;
                    }
                    if (exceptionHandler == null) continue;
                    exceptionHandler.connectionCreationFailure(null, e);
                    continue;
                }
                c = new LDAPListenerClientConnection(this, (Socket)s, this.config.getRequestHandler(), this.config.getExceptionHandler());
            }
            break block19;
            {
                catch (LDAPException le) {
                    Debug.debugException(le);
                    if (exceptionHandler == null) continue;
                    exceptionHandler.connectionCreationFailure((Socket)s, le);
                    continue;
                }
                int maxConnections = this.config.getMaxConnections();
                if (maxConnections > 0 && this.establishedConnections.size() >= maxConnections) {
                    c.close(new LDAPException(ResultCode.BUSY, ListenerMessages.ERR_LDAP_LISTENER_MAX_CONNECTIONS_ESTABLISHED.get(maxConnections)));
                    continue;
                }
                this.establishedConnections.put(c.getConnectionID(), c);
                c.start();
                continue;
                break;
            }
            finally {
                s = this.serverSocket.getAndSet(null);
                if (s != null) {
                    try {
                        ((ServerSocket)s).close();
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                }
                this.serverSocket.set(null);
                this.thread.set(null);
            }
        }
    }

    public void closeAllConnections(boolean sendNoticeOfDisconnection) {
        NoticeOfDisconnectionExtendedResult noticeOfDisconnection = new NoticeOfDisconnectionExtendedResult(ResultCode.OTHER, null, new Control[0]);
        ArrayList<LDAPListenerClientConnection> connList = new ArrayList<LDAPListenerClientConnection>(this.establishedConnections.values());
        for (LDAPListenerClientConnection c : connList) {
            if (sendNoticeOfDisconnection) {
                try {
                    c.sendUnsolicitedNotification(noticeOfDisconnection);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
            try {
                c.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
    }

    public void shutDown(boolean closeExisting) {
        Thread t;
        this.stopRequested.set(true);
        ServerSocket s = this.serverSocket.get();
        if (s != null) {
            try {
                s.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        if ((t = this.thread.get()) != null) {
            while (t.isAlive()) {
                block10: {
                    try {
                        t.join(100L);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        if (!(e instanceof InterruptedException)) break block10;
                        Thread.currentThread().interrupt();
                    }
                }
                if (!t.isAlive()) continue;
                try {
                    t.interrupt();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        if (closeExisting) {
            this.closeAllConnections(false);
        }
    }

    public InetAddress getListenAddress() {
        ServerSocket s = this.serverSocket.get();
        if (s == null) {
            return null;
        }
        return s.getInetAddress();
    }

    public int getListenPort() {
        ServerSocket s = this.serverSocket.get();
        if (s == null) {
            return -1;
        }
        return s.getLocalPort();
    }

    LDAPListenerConfig getConfig() {
        return this.config;
    }

    long nextConnectionID() {
        return this.nextConnectionID.getAndIncrement();
    }

    void connectionClosed(LDAPListenerClientConnection connection) {
        this.establishedConnections.remove(connection.getConnectionID());
    }
}

