/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.sdo.SDOChangeSummary;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;

public class ListWrapper
implements List,
Serializable,
Cloneable {
    protected SDODataObject dataObject;
    protected SDOProperty property;
    protected List currentElements = this.getEmptyList();

    private List getEmptyList() {
        return new ArrayList();
    }

    public ListWrapper() {
    }

    public ListWrapper(SDODataObject theDataObject, Property theProperty) {
        this();
        this.dataObject = theDataObject;
        this.property = (SDOProperty)theProperty;
    }

    public ListWrapper(SDODataObject theDataObject, Property theProperty, List theList) {
        this(theDataObject, theProperty);
        this.currentElements = theList;
    }

    public boolean add(Object item) {
        return this.add(item, true);
    }

    public boolean add(Object item, boolean updateSequence) {
        SDOProperty oppositeProp;
        if (item == null && this.property != null && !this.property.isNullable()) {
            throw new UnsupportedOperationException("Property [" + this.property.getName() + "] is non-nullable");
        }
        this.copyElements();
        boolean result = this.currentElements.add(item);
        this.updateContainment(item, updateSequence);
        if (this.property != null && item != null && (oppositeProp = this.property.getOpposite()) != null) {
            ((DataObject)item).set((Property)oppositeProp, (Object)this.dataObject);
        }
        return result;
    }

    public void add(int index, Object item) {
        this.add(index, item, true);
    }

    public void add(int index, Object item, boolean updateSequence) {
        SDOProperty oppositeProp;
        if (item == null && this.property != null && !this.property.isNullable()) {
            throw new UnsupportedOperationException("Property [" + this.property.getName() + "] is non-nullable");
        }
        if (index < 0 || index > this.size()) {
            return;
        }
        this.copyElements();
        this.currentElements.add(index, item);
        this.updateContainment(item, updateSequence);
        if (this.property != null && item != null && (oppositeProp = this.property.getOpposite()) != null) {
            ((DataObject)item).set((Property)oppositeProp, (Object)this.dataObject);
            this.dataObject.set(oppositeProp, null);
        }
    }

    protected boolean isLogging() {
        return this.dataObject != null && this.dataObject.getChangeSummary() != null && this.dataObject.getChangeSummary().isLogging();
    }

    protected void copyElements() {
        if (this.isLogging() && !this.dataObject.getChangeSummary().isDirty(this)) {
            this.dataObject.getChangeSummary().getOriginalElements().put(this, this.currentElements);
            this.currentElements = new ArrayList(this.currentElements);
        }
    }

    public void undoChanges(SDOChangeSummary cs) {
        if (cs == null) {
            return;
        }
        if (cs.isDirty(this)) {
            this.currentElements = (List)cs.getOriginalElements().get(this);
            cs.getOriginalElements().remove(this);
        }
    }

    protected void updateSequence(Property aProperty, Collection items, boolean updateSequence) {
        if (updateSequence) {
            Iterator valuesIter = items.iterator();
            ArrayList duplicatesList = new ArrayList();
            while (valuesIter.hasNext()) {
                Object next = valuesIter.next();
                if (aProperty != null && !((SDOProperty)aProperty).getType().isDataType() && aProperty.isContainment()) {
                    if (duplicatesList.contains(next)) continue;
                    this.updateSequenceSettingInternal(this.property, next);
                    duplicatesList.add(next);
                    continue;
                }
                this.updateSequenceSettingInternal(this.property, next);
            }
        }
    }

    private void updateSequenceSettingInternal(Property aProperty, Object item) {
        if (this.dataObject.getType().isSequenced()) {
            this.dataObject.getSequence().addSettingWithoutModifyingDataObject(this.property, item);
        }
    }

    private void removeSequenceSettingInternal(int occurrence, Property aProperty, Object item) {
        if (this.dataObject.getType().isSequenced()) {
            this.dataObject.getSequence().removeSettingWithoutModifyingDataObject(this.property, item);
        }
    }

    protected void updateContainment(Object item, boolean updateSequence) {
        if (this.property != null && this.property.isContainment() && item instanceof SDODataObject) {
            this.dataObject.updateContainment((Property)this.property, (SDODataObject)item);
        } else if (this.dataObject != null) {
            this.dataObject._setModified(true);
        }
        if (this.property != null && updateSequence) {
            this.updateSequenceSettingInternal(this.property, item);
        }
    }

    protected void updateContainment(Collection items, boolean updateSequence) {
        if (this.property != null && this.property.isContainment()) {
            this.dataObject.updateContainment((Property)this.property, items, updateSequence);
        } else if (this.dataObject != null) {
            this.dataObject._setModified(true);
        }
    }

    protected void removeContainment(Object item, boolean fromDelete, boolean updateSequence) {
        this.removeContainment(0, item, fromDelete, updateSequence);
    }

    protected void removeContainment(int occurrence, Object item, boolean fromDelete, boolean updateSequence) {
        if (this.property != null && this.property.isContainment() && item != null) {
            ((SDODataObject)item).detachOrDelete(fromDelete);
        } else {
            this.dataObject._setModified(true);
        }
        if (this.property != null && this.dataObject.getType().isSequenced() && updateSequence) {
            this.removeSequenceSettingInternal(occurrence, this.property, item);
        }
    }

    public boolean remove(Object item, boolean fromDelete, boolean updateSequence) {
        this.copyElements();
        this.removeContainment(item, fromDelete, updateSequence);
        return this.currentElements.remove(item);
    }

    public boolean remove(Object item) {
        return this.remove(item, false, true);
    }

    public boolean addAll(Collection items) {
        return this.addAll(items, true);
    }

    public boolean addAll(Collection items, boolean updateSequence) {
        SDOProperty oppositeProp;
        if (items.contains(null) && this.property != null && !this.property.isNullable()) {
            throw new UnsupportedOperationException("Property [" + this.property.getName() + "] is non-nullable");
        }
        this.copyElements();
        boolean modified = this.currentElements.addAll(items);
        this.dataObject._getCurrentValueStore().setManyProperty(this.property, this);
        this.updateContainment(items, updateSequence);
        if (this.property != null && (oppositeProp = this.property.getOpposite()) != null) {
            for (Object item : items) {
                if (item == null) continue;
                ((DataObject)item).set((Property)oppositeProp, (Object)this.dataObject);
            }
        }
        this.updateSequence(this.property, items, updateSequence);
        return modified;
    }

    public boolean addAll(int position, Collection items) {
        return this.addAll(position, items, true);
    }

    public boolean addAll(int position, Collection items, boolean updateSequence) {
        SDOProperty oppositeProp;
        if (position < 0 || position > this.size()) {
            return false;
        }
        if (items == null || items.size() == 0) {
            return false;
        }
        if (items.contains(null) && this.property != null && !this.property.isNullable()) {
            throw new UnsupportedOperationException("Property [" + this.property.getName() + "] is non-nullable");
        }
        this.copyElements();
        boolean modified = this.currentElements.addAll(position, items);
        this.updateContainment(items, updateSequence);
        if (this.property != null && (oppositeProp = this.property.getOpposite()) != null) {
            for (Object item : items) {
                if (item == null) continue;
                ((DataObject)item).set((Property)oppositeProp, (Object)this.dataObject);
                this.dataObject.set(oppositeProp, null);
            }
        }
        this.updateSequence(this.property, items, updateSequence);
        return modified;
    }

    public boolean removeAll(Collection items) {
        return this.removeAll(items, true);
    }

    public boolean removeAll(Collection items, boolean updateSequence) {
        Iterator iter = items.iterator();
        boolean modified = false;
        while (iter.hasNext()) {
            Object next = iter.next();
            this.remove(next, false, updateSequence);
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(Collection itemsToKeep) {
        if (itemsToKeep == null) {
            return false;
        }
        if (itemsToKeep.size() == 0) {
            this.clear();
            return true;
        }
        boolean modified = false;
        int originalSize = this.size();
        int index = 0;
        int original = 0;
        while (original < originalSize) {
            Object anObject = this.get(index);
            if (!itemsToKeep.contains(anObject)) {
                this.remove(anObject);
                modified = true;
            } else {
                ++index;
            }
            ++original;
        }
        return modified;
    }

    public void clear() {
        this.clear(true);
    }

    public void clear(boolean updateSequence) {
        int size = this.size();
        int i = size - 1;
        while (i >= 0) {
            this.remove(i, updateSequence);
            --i;
        }
    }

    public Object set(int index, Object item) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("index " + index + " is out of bounds.");
        }
        Object aPreviousObject = this.remove(index);
        this.add(index, item);
        return aPreviousObject;
    }

    public Object remove(int index, boolean updateSequence) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        this.copyElements();
        int occurrence = this.getOccurrenceIndex(index);
        this.removeContainment(occurrence, this.currentElements.get(index), false, updateSequence);
        return this.currentElements.remove(index);
    }

    private int getOccurrenceIndex(int index) {
        int occurrence = 0;
        boolean skipFirstOccurrence = true;
        Object targetObjectAtIndex = this.currentElements.get(index);
        int position = 0;
        int size = this.size();
        while (position < size && position < index + 1) {
            Object searchIndexObject = this.currentElements.get(position);
            if (targetObjectAtIndex == searchIndexObject) {
                if (skipFirstOccurrence) {
                    skipFirstOccurrence = false;
                } else {
                    ++occurrence;
                }
            }
            ++position;
        }
        return occurrence;
    }

    public Object remove(int index) {
        return this.remove(index, true);
    }

    public ListIterator listIterator() {
        return this.currentElements.listIterator();
    }

    public ListIterator listIterator(int position) {
        return this.currentElements.listIterator(position);
    }

    public List subList(int start, int end) {
        return this.currentElements.subList(start, end);
    }

    public Object[] toArray() {
        return this.currentElements.toArray();
    }

    public Object[] toArray(Object[] items) {
        return this.currentElements.toArray(items);
    }

    public int size() {
        return this.currentElements.size();
    }

    public boolean isEmpty() {
        return this.currentElements.isEmpty();
    }

    public boolean contains(Object item) {
        return this.currentElements.contains(item);
    }

    public boolean containsAll(Collection items) {
        return this.currentElements.containsAll(items);
    }

    public Iterator iterator() {
        return this.currentElements.iterator();
    }

    public int indexOf(Object item) {
        return this.currentElements.indexOf(item);
    }

    public int lastIndexOf(Object item) {
        return this.currentElements.lastIndexOf(item);
    }

    public Object get(int position) {
        try {
            return this.currentElements.get(position);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object writeReplace() {
        return this.currentElements;
    }

    public List getCurrentElements() {
        return this.currentElements;
    }

    public void setCurrentElements(List currentElementsList) {
        this.currentElements = currentElementsList;
    }

    public Object clone() {
        ListWrapper listWrapperClone = new ListWrapper(this.dataObject, this.property);
        listWrapperClone.setCurrentElements(new ArrayList(this.currentElements));
        return listWrapperClone;
    }
}

