/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.IOException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.XMLFragmentReader;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.record.WriterRecord;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FormattedWriterRecord
extends WriterRecord {
    private static final char[] TAB = "   ".toCharArray();
    private int numberOfTabs = 0;
    private boolean complexType = true;
    private boolean isLastEventText = false;

    public void endDocument() {
        try {
            this.writer.write(Helper.cr());
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.addPositionalNodes(xPathFragment, namespaceResolver);
        try {
            if (this.isStartElementOpen) {
                this.writer.write(62);
            }
            if (!this.isLastEventText) {
                if (this.numberOfTabs > 0) {
                    this.writer.write(Helper.cr());
                }
                int x = 0;
                while (x < this.numberOfTabs) {
                    this.writer.write(TAB);
                    ++x;
                }
            }
            this.isStartElementOpen = true;
            this.writer.write(60);
            this.writer.write(xPathFragment.getShortName());
            ++this.numberOfTabs;
            this.isLastEventText = false;
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void element(XPathFragment frag) {
        try {
            this.isLastEventText = false;
            if (this.isStartElementOpen) {
                this.writer.write(62);
                this.isStartElementOpen = false;
            }
            this.writer.write(Helper.cr());
            int x = 0;
            while (x < this.numberOfTabs) {
                this.writer.write(TAB);
                ++x;
            }
            super.element(frag);
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        try {
            this.isLastEventText = false;
            --this.numberOfTabs;
            if (this.isStartElementOpen) {
                this.writer.write(47);
                this.writer.write(62);
                this.isStartElementOpen = false;
                return;
            }
            if (this.complexType) {
                this.writer.write(Helper.cr());
                int x = 0;
                while (x < this.numberOfTabs) {
                    this.writer.write(TAB);
                    ++x;
                }
            } else {
                this.complexType = true;
            }
            super.endElement(xPathFragment, namespaceResolver);
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void characters(String value) {
        super.characters(value);
        this.isLastEventText = true;
        this.complexType = false;
    }

    public void cdata(String value) {
        try {
            if (this.isStartElementOpen) {
                this.writer.write(62);
                this.isStartElementOpen = false;
            }
            super.cdata(value);
            this.complexType = false;
        }
        catch (IOException ex) {
            throw XMLMarshalException.marshalException(ex);
        }
    }

    public void node(Node node, NamespaceResolver namespaceResolver) {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String resolverPfx = null;
            if (this.getNamespaceResolver() != null) {
                resolverPfx = this.getNamespaceResolver().resolveNamespaceURI(attr.getNamespaceURI());
            }
            if (resolverPfx != null) {
                this.attribute(attr.getNamespaceURI(), "", String.valueOf(resolverPfx) + ':' + attr.getLocalName(), attr.getNodeValue());
            } else {
                this.attribute(attr.getNamespaceURI(), "", attr.getName(), attr.getNodeValue());
                if (attr.getNamespaceURI() != null) {
                    this.attribute("http://www.w3.org/2000/xmlns/", "", "xmlns:" + attr.getPrefix(), attr.getNamespaceURI());
                    this.getNamespaceResolver().put(attr.getPrefix(), attr.getNamespaceURI());
                }
            }
        } else if (node.getNodeType() == 3) {
            this.characters(node.getNodeValue());
        } else {
            try {
                FormattedWriterRecordContentHandler wrcHandler = new FormattedWriterRecordContentHandler();
                XMLFragmentReader xfragReader = new XMLFragmentReader(namespaceResolver);
                xfragReader.setContentHandler(wrcHandler);
                xfragReader.setProperty("http://xml.org/sax/properties/lexical-handler", wrcHandler);
                xfragReader.parse(node);
            }
            catch (SAXException sex) {
                throw XMLMarshalException.marshalException(sex);
            }
        }
    }

    private class FormattedWriterRecordContentHandler
    extends WriterRecord.WriterRecordContentHandler {
        private FormattedWriterRecordContentHandler() {
            super(FormattedWriterRecord.this);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            try {
                if (FormattedWriterRecord.this.isStartElementOpen) {
                    FormattedWriterRecord.this.writer.write(62);
                }
                if (!FormattedWriterRecord.this.isLastEventText) {
                    FormattedWriterRecord.this.writer.write(Helper.cr());
                    int x = 0;
                    while (x < FormattedWriterRecord.this.numberOfTabs) {
                        FormattedWriterRecord.this.writer.write(TAB);
                        ++x;
                    }
                }
                FormattedWriterRecord.this.writer.write(60);
                FormattedWriterRecord.this.writer.write(qName);
                FormattedWriterRecord formattedWriterRecord = FormattedWriterRecord.this;
                formattedWriterRecord.numberOfTabs = formattedWriterRecord.numberOfTabs + 1;
                FormattedWriterRecord.this.isStartElementOpen = true;
                FormattedWriterRecord.this.isLastEventText = false;
                this.handleAttributes(atts);
                this.writePrefixMappings();
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            try {
                FormattedWriterRecord.this.isLastEventText = false;
                FormattedWriterRecord formattedWriterRecord = FormattedWriterRecord.this;
                formattedWriterRecord.numberOfTabs = formattedWriterRecord.numberOfTabs - 1;
                if (FormattedWriterRecord.this.isStartElementOpen) {
                    FormattedWriterRecord.this.writer.write(47);
                    FormattedWriterRecord.this.writer.write(62);
                    FormattedWriterRecord.this.isStartElementOpen = false;
                    FormattedWriterRecord.this.complexType = true;
                    return;
                }
                if (FormattedWriterRecord.this.complexType) {
                    FormattedWriterRecord.this.writer.write(Helper.cr());
                    int x = 0;
                    while (x < FormattedWriterRecord.this.numberOfTabs) {
                        FormattedWriterRecord.this.writer.write(TAB);
                        ++x;
                    }
                } else {
                    FormattedWriterRecord.this.complexType = true;
                }
                super.endElement(namespaceURI, localName, qName);
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (FormattedWriterRecord.this.isProcessingCData) {
                FormattedWriterRecord.this.cdata(new String(ch, start, length));
                return;
            }
            if (new String(ch).trim().length() == 0) {
                return;
            }
            super.characters(ch, start, length);
            FormattedWriterRecord.this.isLastEventText = true;
            FormattedWriterRecord.this.complexType = false;
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            try {
                if (FormattedWriterRecord.this.isStartElementOpen) {
                    FormattedWriterRecord.this.writer.write(62);
                    FormattedWriterRecord.this.writer.write(Helper.cr());
                    FormattedWriterRecord.this.isStartElementOpen = false;
                }
                this.writeComment(ch, start, length);
                FormattedWriterRecord.this.complexType = false;
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }
    }
}

