/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.Vector;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class ArrayRecord
extends DatabaseRecord {
    protected DatabaseField[] fieldsArray;
    protected Object[] valuesArray;

    public ArrayRecord(Vector fields, DatabaseField[] fieldsArray, Object[] valuesArray) {
        super(fields, null);
        this.fieldsArray = fieldsArray;
        this.valuesArray = valuesArray;
        this.size = fieldsArray.length;
    }

    protected void checkValues() {
        if (this.values == null) {
            this.values = new NonSynchronizedVector(this.valuesArray.length);
            Object[] objectArray = this.valuesArray;
            int n = this.valuesArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                this.values.add(value);
                ++n2;
            }
        }
    }

    public void add(DatabaseField key, Object value) {
        this.checkValues();
        this.fieldsArray = null;
        this.valuesArray = null;
        super.add(key, value);
    }

    public void clear() {
        this.checkValues();
        this.fieldsArray = null;
        this.valuesArray = null;
        super.clear();
    }

    public AbstractRecord clone() {
        this.checkValues();
        return super.clone();
    }

    public boolean containsKey(DatabaseField key) {
        if (this.fieldsArray != null) {
            DatabaseField field;
            int index = key.getIndex();
            if (index >= 0 && index < this.size && ((field = this.fieldsArray[index]) == key || field.equals(key))) {
                return true;
            }
            DatabaseField[] databaseFieldArray = this.fieldsArray;
            int n = this.fieldsArray.length;
            int n2 = 0;
            while (n2 < n) {
                field = databaseFieldArray[n2];
                if (field == key || field.equals(key)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return super.containsKey(key);
    }

    public boolean containsValue(Object value) {
        if (this.valuesArray != null) {
            Object[] objectArray = this.valuesArray;
            int n = this.valuesArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object rowValue = objectArray[n2];
                if (value == rowValue || rowValue.equals(value)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return super.containsValue(value);
    }

    public Object get(DatabaseField key) {
        if (this.fieldsArray != null) {
            DatabaseField field;
            int index = key.getIndex();
            if (index >= 0 && index < this.size && ((field = this.fieldsArray[index]) == key || field.equals(key))) {
                return this.valuesArray[index];
            }
            int fieldIndex = 0;
            while (fieldIndex < this.size) {
                DatabaseField field2 = this.fieldsArray[fieldIndex];
                if (field2 == key || field2.equals(key)) {
                    if (index == -1) {
                        key.setIndex(fieldIndex);
                    }
                    return this.valuesArray[fieldIndex];
                }
                ++fieldIndex;
            }
            return null;
        }
        return super.get(key);
    }

    public Object getIndicatingNoEntry(DatabaseField key) {
        if (this.fieldsArray != null) {
            DatabaseField field;
            int index = key.getIndex();
            if (index >= 0 && index < this.size && ((field = this.fieldsArray[index]) == key || field.equals(key))) {
                return this.valuesArray[index];
            }
            int fieldIndex = 0;
            while (fieldIndex < this.size) {
                DatabaseField field2 = this.fieldsArray[fieldIndex];
                if (field2 == key || field2.equals(key)) {
                    if (index == -1) {
                        key.setIndex(fieldIndex);
                    }
                    return this.valuesArray[fieldIndex];
                }
                ++fieldIndex;
            }
            return AbstractRecord.noEntry;
        }
        return super.get(key);
    }

    public DatabaseField getField(DatabaseField key) {
        if (this.fieldsArray != null) {
            DatabaseField field;
            int index = key.getIndex();
            if (index >= 0 && index < this.size && ((field = this.fieldsArray[index]) == key || field.equals(key))) {
                return field;
            }
            int fieldIndex = 0;
            while (fieldIndex < this.size) {
                DatabaseField field2 = this.fieldsArray[fieldIndex];
                if (field2 == key || field2.equals(key)) {
                    return field2;
                }
                ++fieldIndex;
            }
            return null;
        }
        return super.getField(key);
    }

    public Vector getFields() {
        this.checkValues();
        return super.getFields();
    }

    public Vector getValues() {
        this.checkValues();
        return super.getValues();
    }

    public Object put(DatabaseField key, Object value) {
        this.checkValues();
        this.fieldsArray = null;
        this.valuesArray = null;
        return super.put(key, value);
    }

    public Object remove(DatabaseField key) {
        this.checkValues();
        this.fieldsArray = null;
        this.valuesArray = null;
        return super.remove(key);
    }

    public void replaceAt(Object value, int index) {
        this.checkValues();
        this.fieldsArray = null;
        this.valuesArray = null;
        super.replaceAt(value, index);
    }

    protected void setFields(Vector fields) {
        this.checkValues();
        this.fieldsArray = null;
        this.valuesArray = null;
        super.setFields(fields);
    }

    protected void setValues(Vector values) {
        this.checkValues();
        this.fieldsArray = null;
        this.valuesArray = null;
        super.setValues(values);
    }

    public int size() {
        if (this.fieldsArray == null) {
            return this.fields.size();
        }
        return this.fieldsArray.length;
    }
}

