/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sequencing;

import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.sequencing.SequencingConnectionHandler;
import org.eclipse.persistence.sessions.server.ConnectionPool;

class ServerSessionConnectionHandler
implements SequencingConnectionHandler {
    ConnectionPool pool;

    ServerSessionConnectionHandler(ConnectionPool pool) {
        this.pool = pool;
    }

    public void onConnect() {
        if (!this.isConnected()) {
            this.pool.startUp();
        }
    }

    public boolean isConnected() {
        return this.pool.isConnected();
    }

    public Accessor acquireAccessor() {
        return this.pool.acquireConnection();
    }

    public ConnectionPool getPool() {
        return this.pool;
    }

    public void releaseAccessor(Accessor accessor) {
        this.pool.releaseConnection(accessor);
    }

    public void onDisconnect() {
        if (this.isConnected()) {
            this.pool.shutDown();
        }
    }

    protected void finalize() throws Throwable {
        this.onDisconnect();
    }
}

