/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.objects;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Temporal;
import javax.persistence.Version;
import org.eclipse.persistence.annotations.Array;
import org.eclipse.persistence.annotations.BasicCollection;
import org.eclipse.persistence.annotations.BasicMap;
import org.eclipse.persistence.annotations.ReadTransformer;
import org.eclipse.persistence.annotations.Structure;
import org.eclipse.persistence.annotations.TransientCompatibleAnnotations;
import org.eclipse.persistence.annotations.VariableOneToOne;
import org.eclipse.persistence.annotations.WriteTransformer;
import org.eclipse.persistence.annotations.WriteTransformers;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataAnnotatedElement
extends MetadataAccessibleObject {
    public static final String DEFAULT_RAW_CLASS = "java.lang.String";
    public static final String JPA_PERSISTENCE_PACKAGE_PREFIX = "javax.persistence";
    public static final String ECLIPSELINK_PERSISTENCE_PACKAGE_PREFIX = "org.eclipse.persistence.annotations";
    private String m_name;
    private int m_modifiers;
    private MetadataClass m_rawClass;
    private List<String> m_genericType;
    private String m_type;
    Object m_primitiveType;
    private String m_attributeName;
    private Map<String, MetadataAnnotation> m_annotations = new HashMap<String, MetadataAnnotation>();

    public MetadataAnnotatedElement(MetadataFactory factory) {
        super(factory);
    }

    public void addAnnotation(MetadataAnnotation annotation) {
        this.m_annotations.put(annotation.getName(), annotation);
    }

    public void addGenericType(String genericType) {
        if (this.m_genericType == null) {
            this.m_genericType = new ArrayList<String>();
        }
        this.m_genericType.add(genericType);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getName() == null) {
            return ((MetadataAnnotatedElement)object).getName() == null;
        }
        return object.getClass() == this.getClass() && this.getName().equals(((MetadataAnnotatedElement)object).getName());
    }

    public MetadataAnnotation getAnnotation(Class annotation) {
        if (this.m_annotations == null) {
            return null;
        }
        return this.m_annotations.get(annotation.getName());
    }

    public MetadataAnnotation getAnnotation(String annotationClassName, ClassAccessor classAccessor) {
        if (this.m_annotations != null) {
            MetadataAnnotation annotation = this.m_annotations.get(annotationClassName);
            if (annotation != null && classAccessor.ignoreAnnotations()) {
                this.getLogger().logConfigMessage("annotation_warning_ignore_annotation", annotation, (Object)this);
            } else {
                return annotation;
            }
        }
        return null;
    }

    public Map<String, MetadataAnnotation> getAnnotations() {
        return this.m_annotations;
    }

    @Override
    public String getAttributeName() {
        return this.m_attributeName;
    }

    protected int getDeclaredAnnotationsCount(ClassAccessor classAccessor) {
        if (classAccessor.ignoreAnnotations() || this.m_annotations == null) {
            return 0;
        }
        return this.m_annotations.size();
    }

    public List<String> getGenericType() {
        return this.m_genericType;
    }

    public MetadataClass getMapKeyClass(MetadataDescriptor descriptor) {
        if (this.isGenericCollectionType()) {
            String type = descriptor.getGenericType(this.m_genericType.get(2));
            if (type != null) {
                return this.getMetadataClass(type);
            }
            return this.getMetadataClass(this.m_genericType.get(1));
        }
        return null;
    }

    public int getModifiers() {
        return this.m_modifiers;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public Object getPrimitiveType() {
        return this.m_primitiveType;
    }

    public MetadataClass getRawClass(MetadataDescriptor descriptor) {
        if (this.m_rawClass == null) {
            if (this.isGenericType()) {
                String type = descriptor.getGenericType(this.getGenericType().get(1));
                if (type == null) {
                    return this.getMetadataClass(DEFAULT_RAW_CLASS);
                }
                return this.getMetadataClass(type);
            }
            return this.getMetadataClass(this.getType());
        }
        return this.m_rawClass;
    }

    public MetadataClass getReferenceClassFromGeneric(MetadataDescriptor descriptor) {
        if (this.isGenericCollectionType()) {
            MetadataClass metadataClass;
            String elementClass = this.m_genericType.get(1);
            if (this.m_genericType.size() > 2) {
                MetadataClass collectionClass = this.getMetadataClass(this.m_genericType.get(0));
                if (collectionClass.extendsInterface(Map.class)) {
                    if (this.m_genericType.size() > 4) {
                        elementClass = this.m_genericType.get(4);
                    } else if (this.m_genericType.size() == 4) {
                        elementClass = this.m_genericType.get(3);
                    } else if (this.m_genericType.size() == 3) {
                        elementClass = this.m_genericType.get(2);
                    }
                } else if (elementClass.length() == 1) {
                    elementClass = this.m_genericType.get(2);
                }
            }
            if (elementClass.length() == 1) {
                elementClass = descriptor.getGenericType(elementClass);
            }
            if ((metadataClass = this.getMetadataClass(elementClass)) == null && descriptor.isMappedSuperclass()) {
                return new MetadataClass(this.getMetadataFactory(), Void.class);
            }
            return metadataClass;
        }
        return null;
    }

    public String getType() {
        return this.m_type;
    }

    public boolean hasDeclaredAnnotations(ClassAccessor classAccessor) {
        return this.getDeclaredAnnotationsCount(classAccessor) > 0;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean areAnnotationsCompatibleWithTransient(ClassAccessor classAccessor) {
        int legalAnnotationCount = 1;
        Iterator<String> annotations = TransientCompatibleAnnotations.getTransientCompatibleAnnotations().iterator();
        while (annotations.hasNext()) {
            if (!this.m_annotations.containsKey(annotations.next())) continue;
            ++legalAnnotationCount;
        }
        return this.getDeclaredAnnotationsCount(classAccessor) <= legalAnnotationCount;
    }

    public boolean isAnnotationNotPresent(Class annotation) {
        return !this.isAnnotationPresent(annotation);
    }

    public boolean isAnnotationPresent(Class annotation) {
        return this.getAnnotation(annotation) != null;
    }

    public boolean isAnnotationPresent(Class annotationClass, ClassAccessor accessor) {
        MetadataAnnotation annotation = this.getAnnotation(annotationClass);
        if (annotation != null && accessor.ignoreAnnotations()) {
            this.getLogger().logConfigMessage("annotation_warning_ignore_annotation", annotation, (Object)this);
            return false;
        }
        return annotation != null;
    }

    public boolean isBasic(ClassAccessor classAccessor) {
        return this.isAnnotationPresent(Basic.class, classAccessor) || this.isAnnotationPresent(Lob.class, classAccessor) || this.isAnnotationPresent(Temporal.class, classAccessor) || this.isAnnotationPresent(Enumerated.class, classAccessor);
    }

    public boolean isBasicCollection(ClassAccessor classAccessor) {
        return this.isAnnotationPresent(BasicCollection.class, classAccessor);
    }

    public boolean isBasicMap(ClassAccessor classAccessor) {
        return this.isAnnotationPresent(BasicMap.class, classAccessor);
    }

    public boolean isDerivedId(ClassAccessor classAccessor) {
        return this.isId(classAccessor) && (this.isOneToOne(classAccessor) || this.isManyToOne(classAccessor));
    }

    public boolean isElementCollection(ClassAccessor classAccessor) {
        return this.isAnnotationPresent(ElementCollection.class, classAccessor);
    }

    public boolean isEmbedded(ClassAccessor classAccessor) {
        if (this.isAnnotationNotPresent(Embedded.class) && this.isAnnotationNotPresent(EmbeddedId.class) && !classAccessor.excludeDefaultMappings()) {
            MetadataClass rawClass = this.getRawClass(classAccessor.getDescriptor());
            return rawClass.isAnnotationPresent(Embeddable.class) || classAccessor.getProject().hasEmbeddable(rawClass);
        }
        return this.isAnnotationPresent(Embedded.class, classAccessor);
    }

    public boolean isEmbeddedId(ClassAccessor classAccessor) {
        return this.isAnnotationPresent(EmbeddedId.class, classAccessor);
    }

    public boolean isGenericCollectionType() {
        return this.m_genericType != null && this.m_genericType.size() > 1;
    }

    public boolean isGenericType() {
        return this.m_genericType != null && this.m_genericType.size() > 1 && this.m_genericType.get(0).length() == 1;
    }

    public boolean isId(ClassAccessor classAccessor) {
        return this.isAnnotationPresent(Id.class, classAccessor);
    }

    public boolean isDerivedIdClass(ClassAccessor classAccessor) {
        return classAccessor.getDescriptor().isEmbeddable() && classAccessor.getProject().isIdClass(this.getRawClass(classAccessor.getDescriptor()));
    }

    public boolean isManyToMany(ClassAccessor classAccessor) {
        return this.isAnnotationPresent(ManyToMany.class, classAccessor);
    }

    public boolean isStructure(ClassAccessor classAccessor) {
        return this.isAnnotationPresent(Structure.class, classAccessor);
    }

    public boolean isArray(ClassAccessor classAccessor) {
        return this.isAnnotationPresent(Array.class, classAccessor);
    }

    public boolean isManyToOne(ClassAccessor classAccessor) {
        return this.isAnnotationPresent(ManyToOne.class, classAccessor);
    }

    public boolean isOneToMany(ClassAccessor classAccessor) {
        if (this.isAnnotationNotPresent(OneToMany.class) && !classAccessor.excludeDefaultMappings()) {
            if (this.isGenericCollectionType() && this.isSupportedToManyCollectionClass(this.getRawClass(classAccessor.getDescriptor())) && classAccessor.getProject().hasEntity(this.getReferenceClassFromGeneric(classAccessor.getDescriptor()))) {
                this.getLogger().logConfigMessage("metadata_default_one_to_many_mapping", this);
                return true;
            }
            return false;
        }
        return this.isAnnotationPresent(OneToMany.class, classAccessor);
    }

    public boolean isOneToOne(ClassAccessor classAccessor) {
        if (this.isAnnotationNotPresent(OneToOne.class) && !classAccessor.excludeDefaultMappings()) {
            if (classAccessor.getProject().hasEntity(this.getRawClass(classAccessor.getDescriptor())) && !this.isEmbedded(classAccessor)) {
                this.getLogger().logConfigMessage("metadata_default_one_to_one_mapping", this);
                return true;
            }
            return false;
        }
        return this.isAnnotationPresent(OneToOne.class, classAccessor);
    }

    public boolean isSupportedCollectionClass(MetadataClass metadataClass) {
        return metadataClass.isCollection();
    }

    public boolean isSupportedMapClass(MetadataClass metadataClass) {
        return metadataClass.isMap();
    }

    public boolean isSupportedToManyCollectionClass(MetadataClass metadataClass) {
        return this.isSupportedCollectionClass(metadataClass) || this.isSupportedMapClass(metadataClass);
    }

    public boolean isTransformation(ClassAccessor classAccessor) {
        return this.isAnnotationPresent(ReadTransformer.class, classAccessor) || this.isAnnotationPresent(WriteTransformers.class, classAccessor) || this.isAnnotationPresent(WriteTransformer.class, classAccessor);
    }

    protected boolean isValidPersistenceElement(boolean mustBeExplicit, String explicitType, ClassAccessor classAccessor) {
        if (mustBeExplicit) {
            MetadataAnnotation annotation = this.getAnnotation("javax.persistence.Access", classAccessor);
            if (annotation == null) {
                return false;
            }
            String access = (String)annotation.getAttribute("value");
            if (!access.equals(explicitType)) {
                throw ValidationException.invalidExplicitAccessTypeSpecified(this, classAccessor.getDescriptorJavaClass(), explicitType);
            }
        }
        return true;
    }

    protected boolean isValidPersistenceElement(int modifiers) {
        return !Modifier.isTransient(modifiers) && !Modifier.isStatic(modifiers) && !Modifier.isAbstract(modifiers);
    }

    public boolean isVariableOneToOne(ClassAccessor classAccessor) {
        if (this.isAnnotationNotPresent(VariableOneToOne.class) && !classAccessor.excludeDefaultMappings()) {
            MetadataClass rawClass = this.getRawClass(classAccessor.getDescriptor());
            if (rawClass.isInterface() && !rawClass.isMap() && !rawClass.isCollection() && !rawClass.isSerializableInterface() && !rawClass.extendsInterface(ValueHolderInterface.class) && classAccessor.getProject().hasEntityThatImplementsInterface(rawClass.getName())) {
                this.getLogger().logConfigMessage("metadata_default_variable_one_to_one_mapping", this);
                return true;
            }
            return false;
        }
        return this.isAnnotationPresent(VariableOneToOne.class, classAccessor);
    }

    public boolean isVersion(ClassAccessor classAccessor) {
        return this.isAnnotationPresent(Version.class, classAccessor);
    }

    public void setAnnotations(Map<String, MetadataAnnotation> annotations) {
        this.m_annotations = annotations;
    }

    public void setAttributeName(String attributeName) {
        this.m_attributeName = attributeName;
    }

    public void setGenericType(List<String> genericType) {
        this.m_genericType = genericType;
    }

    public void setModifiers(int modifiers) {
        this.m_modifiers = modifiers;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setPrimitiveType(Object primitiveType) {
        this.m_primitiveType = primitiveType;
        this.m_type = primitiveType.toString();
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public String toString() {
        String className = this.getClass().getSimpleName();
        return String.valueOf(className.substring("Metadata".length(), className.length()).toLowerCase()) + " " + this.getName();
    }
}

