/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.SQLDeleteStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.SQLCall;

public class SQLDeleteAllStatement
extends SQLDeleteStatement {
    protected Expression inheritanceExpression;
    protected SQLCall selectCallForExist;
    protected String tableAliasInSelectCallForExist;
    protected SQLCall selectCallForNotExist;
    protected String tableAliasInSelectCallForNotExist;
    protected Vector aliasedFields;
    protected Vector originalFields;
    protected boolean shouldExtractWhereClauseFromSelectCallForExist;

    public void setSelectCallForExist(SQLCall selectCallForExist) {
        this.selectCallForExist = selectCallForExist;
    }

    public SQLCall getSelectCallForExist() {
        return this.selectCallForExist;
    }

    public void setSelectCallForNotExist(SQLCall selectCallForNotExist) {
        this.selectCallForNotExist = selectCallForNotExist;
    }

    public SQLCall getSelectCallForNotExist() {
        return this.selectCallForNotExist;
    }

    public void setTableAliasInSelectCallForExist(String tableAliasInSelectCallForExist) {
        this.tableAliasInSelectCallForExist = tableAliasInSelectCallForExist;
    }

    public String getTableAliasInSelectCallForExist() {
        return this.tableAliasInSelectCallForExist;
    }

    public void setTableAliasInSelectCallForNotExist(String tableAliasInSelectCallForNotExist) {
        this.tableAliasInSelectCallForNotExist = tableAliasInSelectCallForNotExist;
    }

    public String getTableAliasInSelectCallForNotExist() {
        return this.tableAliasInSelectCallForNotExist;
    }

    public void setPrimaryKeyFieldsForAutoJoin(Collection primaryKeyFields) {
        if (primaryKeyFields != null) {
            if (primaryKeyFields instanceof Vector) {
                this.setOriginalFieldsForJoin((Vector)primaryKeyFields);
            } else {
                this.setOriginalFieldsForJoin(new Vector(primaryKeyFields));
            }
            this.setAliasedFieldsForJoin((Vector)this.getOriginalFieldsForJoin().clone());
        } else {
            this.setOriginalFieldsForJoin(null);
            this.setAliasedFieldsForJoin(null);
        }
    }

    public void setOriginalFieldsForJoin(Vector originalFields) {
        this.originalFields = originalFields;
    }

    public Vector getOriginalFieldsForJoin() {
        return this.originalFields;
    }

    public void setAliasedFieldsForJoin(Vector aliasedFields) {
        this.aliasedFields = aliasedFields;
    }

    public Vector getAliasedFieldsForExpression() {
        return this.aliasedFields;
    }

    public void setInheritanceExpression(Expression inheritanceExpression) {
        this.inheritanceExpression = inheritanceExpression;
    }

    public Expression getInheritanceExpression() {
        return this.inheritanceExpression;
    }

    public void setShouldExtractWhereClauseFromSelectCallForExist(boolean shouldExtractWhereClauseFromSelectCallForExist) {
        this.shouldExtractWhereClauseFromSelectCallForExist = shouldExtractWhereClauseFromSelectCallForExist;
    }

    public boolean shouldExtractWhereClauseFromSelectCallForExist() {
        return this.shouldExtractWhereClauseFromSelectCallForExist;
    }

    public DatabaseCall buildCall(AbstractSession session) {
        SQLCall call = (SQLCall)super.buildCall(session);
        CharArrayWriter writer = new CharArrayWriter(100);
        try {
            writer.write(call.getSQLString());
            boolean whereWasPrinted = true;
            if (this.selectCallForExist != null) {
                if (this.shouldExtractWhereClauseFromSelectCallForExist) {
                    whereWasPrinted = this.writeWhere(writer, this.selectCallForExist, call);
                } else {
                    writer.write(" WHERE EXISTS(");
                    this.writeSelect(writer, this.selectCallForExist, this.tableAliasInSelectCallForExist, call, session.getPlatform());
                    writer.write(")");
                }
                if (this.selectCallForExist.isUsesBindingSet() && !this.selectCallForExist.usesBinding(session)) {
                    call.setUsesBinding(false);
                }
            } else if (this.inheritanceExpression != null) {
                writer.write(" WHERE ");
                ExpressionSQLPrinter printer = new ExpressionSQLPrinter(session, this.getTranslationRow(), call, false, this.getBuilder());
                printer.setWriter(writer);
                printer.printExpression(this.inheritanceExpression);
            } else {
                whereWasPrinted = false;
            }
            if (this.selectCallForNotExist != null) {
                if (whereWasPrinted) {
                    writer.write(" AND");
                } else {
                    writer.write(" WHERE");
                }
                writer.write(" NOT EXISTS(");
                this.writeSelect(writer, this.selectCallForNotExist, this.tableAliasInSelectCallForNotExist, call, session.getPlatform());
                writer.write(")");
            }
            call.setSQLString(((Object)writer).toString());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        return call;
    }

    protected void writeSelect(Writer writer, SQLCall selectCall, String tableAliasInSelectCall, SQLCall call, DatasourcePlatform platform) throws IOException {
        String str = selectCall.getSQLString();
        writer.write(str);
        boolean hasWhereClause = str.toUpperCase().indexOf(" WHERE ") >= 0;
        int i = 0;
        while (i < this.originalFields.size()) {
            if (i == 0 && !hasWhereClause) {
                writer.write(" WHERE ");
            } else {
                writer.write(" AND ");
            }
            if (tableAliasInSelectCall != null) {
                writer.write(tableAliasInSelectCall);
                writer.write(46);
            }
            writer.write(((DatabaseField)this.aliasedFields.elementAt(i)).getNameDelimited(platform));
            writer.write(" = ");
            writer.write(this.table.getQualifiedNameDelimited(platform));
            writer.write(46);
            writer.write(((DatabaseField)this.originalFields.elementAt(i)).getNameDelimited(platform));
            ++i;
        }
        call.getParameters().addAll(selectCall.getParameters());
        call.getParameterTypes().addAll(selectCall.getParameterTypes());
    }

    protected boolean writeWhere(Writer writer, SQLCall selectCall, SQLCall call) throws IOException {
        String selectStr = this.selectCallForExist.getSQLString();
        int index = selectStr.toUpperCase().indexOf(" WHERE ");
        if (index < 0) {
            return false;
        }
        String str = selectStr.substring(index);
        writer.write(str);
        call.getParameters().addAll(selectCall.getParameters());
        call.getParameterTypes().addAll(selectCall.getParameterTypes());
        return true;
    }
}

