/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.arp;

import com.sun.grizzly.arp.AsyncExecutor;
import com.sun.grizzly.arp.AsyncTask;
import com.sun.grizzly.arp.DefaultAsyncExecutor;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.TaskBase;
import com.sun.grizzly.tcp.SuspendResponseUtils;
import com.sun.grizzly.util.ThreadAttachment;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.logging.Level;

public class AsyncProcessorTask
extends TaskBase
implements AsyncTask {
    private final ProcessorTask.PostProcessor asyncResponsePostProcessor = new AsyncResponsePostProcessor();
    private AsyncExecutor asyncExecutor;
    private int stage = 0;

    public void doTask() throws IOException {
        boolean continueExecution = true;
        while (continueExecution) {
            try {
                switch (this.stage) {
                    case 0: {
                        continueExecution = this.asyncExecutor.preExecute();
                        if (!continueExecution) {
                            this.asyncExecutor.getAsyncHandler().returnTask(this);
                            return;
                        }
                        this.disableTimeout();
                        this.stage = 1;
                        break;
                    }
                    case 1: {
                        this.stage = 2;
                        this.setAsyncResponsePostProcessor();
                        continueExecution = this.asyncExecutor.interrupt();
                        break;
                    }
                    case 5: {
                        this.stage = 2;
                        this.setAsyncResponsePostProcessor();
                        continueExecution = this.asyncExecutor.execute();
                        break;
                    }
                    case 2: {
                        if (SuspendResponseUtils.removeSuspendedInCurrentThread()) {
                            return;
                        }
                        continueExecution = this.asyncExecutor.postExecute();
                        if (!continueExecution) break;
                        if (this.asyncExecutor.getProcessorTask().hasNextRequest()) {
                            this.asyncExecutor.reset();
                            this.asyncExecutor.getProcessorTask().prepareForNextRequest();
                            this.stage = 0;
                            break;
                        }
                        this.stage = 3;
                        break;
                    }
                    case 3: {
                        this.enableTimeout();
                        this.asyncExecutor.finishExecute();
                        this.asyncExecutor.getAsyncHandler().returnTask(this);
                        return;
                    }
                }
            }
            catch (Throwable t) {
                SelectorThread.logger().log(Level.SEVERE, t.getMessage(), t);
                if (this.stage <= 1) {
                    this.stage = 2;
                    continue;
                }
                this.stage = 0;
                throw new RuntimeException(t);
            }
        }
    }

    public int getStage() {
        return this.stage;
    }

    public void recycle() {
        this.stage = 0;
        if (this.asyncExecutor instanceof DefaultAsyncExecutor) {
            ((DefaultAsyncExecutor)this.asyncExecutor).reset();
        }
    }

    public void setAsyncExecutor(AsyncExecutor asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
    }

    public AsyncExecutor getAsyncExecutor() {
        return this.asyncExecutor;
    }

    public void setStage(int stage) {
        this.stage = stage;
    }

    public void setProcessorTask(ProcessorTask task) {
    }

    public ProcessorTask getProcessorTask() {
        return this.asyncExecutor == null ? null : this.asyncExecutor.getProcessorTask();
    }

    private void disableTimeout() {
        ThreadAttachment attachment = this.obtainAndSetThreadAttachment();
        attachment.setIdleTimeoutDelay(Long.MAX_VALUE);
    }

    private void enableTimeout() {
        ThreadAttachment attachment = this.obtainAndSetThreadAttachment();
        attachment.setIdleTimeoutDelay(Long.MIN_VALUE);
        attachment.setTimeout(System.currentTimeMillis());
    }

    private ThreadAttachment obtainAndSetThreadAttachment() {
        SelectionKey selectionKey = this.asyncExecutor.getProcessorTask().getSelectionKey();
        Object attachment = selectionKey.attachment();
        if (attachment == null || !(attachment instanceof ThreadAttachment)) {
            attachment = AsyncProcessorTask.obtainThreadAttachment();
            selectionKey.attach(attachment);
        }
        return (ThreadAttachment)attachment;
    }

    private static ThreadAttachment obtainThreadAttachment() {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof WorkerThread) {
            return ((WorkerThread)currentThread).getAttachment();
        }
        return new ThreadAttachment();
    }

    private void setAsyncResponsePostProcessor() {
        this.asyncExecutor.getProcessorTask().setAsyncResponsePostProcessor(this.asyncResponsePostProcessor);
    }

    private final class AsyncResponsePostProcessor
    implements ProcessorTask.PostProcessor {
        private AsyncResponsePostProcessor() {
        }

        public boolean postProcess(ProcessorTask processorTask) {
            try {
                AsyncProcessorTask.this.doTask();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
    }
}

