/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.spotify.docker.Git;
import java.io.IOException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;

public class DockerBuildInformation {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    @JsonProperty(value="image")
    private final String image;
    @JsonProperty(value="repo")
    private String repo;
    @JsonProperty(value="commit")
    private String commit;
    @JsonProperty(value="digest")
    private String digest;

    public DockerBuildInformation(String image, Log log) {
        this.image = image;
        this.updateGitInformation(log);
    }

    public DockerBuildInformation setDigest(String digest) {
        this.digest = digest;
        return this;
    }

    private void updateGitInformation(Log log) {
        try {
            Repository repo = new Git().getRepo();
            if (repo != null) {
                this.repo = repo.getConfig().getString("remote", "origin", "url");
                ObjectId head = repo.resolve("HEAD");
                if (head != null && !Strings.isNullOrEmpty((String)head.getName())) {
                    this.commit = head.getName();
                }
            }
        }
        catch (IOException e) {
            log.error((CharSequence)"Failed to read Git information", (Throwable)e);
        }
    }

    public byte[] toJsonBytes() {
        try {
            return OBJECT_MAPPER.writeValueAsBytes((Object)this);
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public String getImage() {
        return this.image;
    }

    public String getRepo() {
        return this.repo;
    }

    public String getCommit() {
        return this.commit;
    }

    public String getDigest() {
        return this.digest;
    }
}

