/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InstrumentationArgumentParser {
    private static final String SEPARATOR = " ";

    public static Map<String, String> parse(List<String> flatArgs) {
        if (flatArgs == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> mappedArgs = new HashMap<String, String>();
        for (String flatArg : flatArgs) {
            AbstractMap.SimpleEntry<String, String> keyValuePair = InstrumentationArgumentParser.parseKeyValuePair(flatArg);
            mappedArgs.put(keyValuePair.getKey(), keyValuePair.getValue());
        }
        return mappedArgs;
    }

    private static AbstractMap.SimpleEntry<String, String> parseKeyValuePair(String arg) {
        ArrayList keyValueSplit = Lists.newArrayList((Iterable)Splitter.on((String)SEPARATOR).limit(2).split((CharSequence)arg));
        if (keyValueSplit.size() == 1) {
            throw new IllegalArgumentException("Could not separate \"" + arg + "\" by a whitespace into two parts");
        }
        return new AbstractMap.SimpleEntry<String, String>((String)keyValueSplit.get(0), (String)keyValueSplit.get(1));
    }
}

