/*
 * Decompiled with CFR 0.152.
 */
package com.samaxes.maven.plugin.minify;

import com.samaxes.maven.plugin.common.JavaScriptErrorReporter;
import com.samaxes.maven.plugin.minify.ProcessFilesTask;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.mozilla.javascript.ErrorReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessJSFilesTask
extends ProcessFilesTask {
    private boolean munge;
    private boolean verbose;
    private boolean preserveAllSemiColons;
    private boolean disableOptimizations;

    public ProcessJSFilesTask(Log log, Integer bufferSize, String webappSourceDir, String webappTargetDir, String inputDir, List<String> sourceFiles, List<String> sourceIncludes, List<String> sourceExcludes, String outputDir, String finalFilename, String suffix, String charset, int linebreak, boolean munge, boolean verbose, boolean preserveAllSemiColons, boolean disableOptimizations) {
        super(log, bufferSize, webappSourceDir, webappTargetDir, inputDir, sourceFiles, sourceIncludes, sourceExcludes, outputDir, finalFilename, suffix, charset, linebreak);
        this.munge = munge;
        this.verbose = verbose;
        this.preserveAllSemiColons = preserveAllSemiColons;
        this.disableOptimizations = disableOptimizations;
    }

    @Override
    protected void minify() {
        if (this.minifiedFile != null) {
            try {
                this.log.info((CharSequence)("Creating minified file [" + this.minifiedFile.getName() + "]"));
                FileReader reader = new FileReader(this.mergedFile);
                FileWriter writer = new FileWriter(this.minifiedFile);
                JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)reader, (ErrorReporter)new JavaScriptErrorReporter(this.log, this.mergedFile.getName()));
                compressor.compress((Writer)writer, this.linebreak, this.munge, this.verbose, this.preserveAllSemiColons, this.disableOptimizations);
                ((Reader)reader).close();
                ((Writer)writer).close();
            }
            catch (IOException e) {
                this.log.error((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
    }
}

