/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.SqlConfigParseUtils;
import org.sagacity.sqltoy.config.model.KeyAndIndex;
import org.sagacity.sqltoy.config.model.ShardingStrategyConfig;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.exception.DataAccessException;
import org.sagacity.sqltoy.model.DataAuthFilterConfig;
import org.sagacity.sqltoy.model.IgnoreKeyCaseMap;
import org.sagacity.sqltoy.model.inner.QueryExecutorExtend;
import org.sagacity.sqltoy.plugins.IUnifyFieldsHandler;
import org.sagacity.sqltoy.utils.BeanUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutorBuilder {
    protected static final Logger logger = LoggerFactory.getLogger(QueryExecutorBuilder.class);

    public static void initQueryExecutor(SqlToyContext sqlToyContext, QueryExecutorExtend extend, SqlToyConfig sqlToyConfig, boolean wrapNamedArgs) {
        QueryExecutorBuilder.initQueryExecutor(sqlToyContext, extend, sqlToyConfig, wrapNamedArgs, true);
    }

    public static void initQueryExecutor(SqlToyContext sqlToyContext, QueryExecutorExtend extend, SqlToyConfig sqlToyConfig, boolean wrapNamedArgs, boolean filterAuthData) {
        Object[] fullParamValues;
        int paramsValueSize;
        if (QueryExecutorBuilder.wrapParamNames(extend, sqlToyConfig, wrapNamedArgs)) {
            return;
        }
        String[] fullParamNames = QueryExecutorBuilder.wrapFullParamNames(sqlToyConfig.getFullParamNames(), extend, sqlToyConfig);
        if (fullParamNames == null || fullParamNames.length == 0) {
            return;
        }
        int paramsNameSize = extend.paramsName == null || extend.paramsName.length == 0 ? -1 : extend.paramsName.length;
        int n = paramsValueSize = extend.paramsValue == null || extend.paramsValue.length == 0 ? -1 : extend.paramsValue.length;
        if (extend.entity != null) {
            fullParamValues = BeanUtil.reflectBeanToAry(extend.entity, fullParamNames);
        } else if (paramsNameSize == -1 && paramsValueSize == 1 && extend.paramsValue[0] != null && !BeanUtil.isBaseDataType(extend.paramsValue[0].getClass())) {
            fullParamValues = BeanUtil.reflectBeanToAry(extend.paramsValue[0], fullParamNames);
        } else {
            if (paramsNameSize != paramsValueSize && (paramsNameSize != 1 || paramsValueSize <= 1)) {
                throw new IllegalArgumentException("\u53c2\u6570\u540d\u79f0\u6570\u7ec4\u957f\u5ea6:" + paramsNameSize + " \u548c\u53c2\u6570\u503c\u6570\u7ec4\u957f\u5ea6:" + paramsValueSize + "\u4e0d\u4e00\u81f4,\u8bf7\u68c0\u67e5!");
            }
            fullParamValues = new Object[fullParamNames.length];
            String[] paramNames = extend.paramsName;
            if (paramNames != null && paramNames.length > 0) {
                int i;
                Object[] paramValues = paramsNameSize == 1 && paramsValueSize > 1 ? new Object[]{extend.paramsValue} : extend.paramsValue;
                HashMap<String, Integer> paramIndexMap = new HashMap<String, Integer>();
                for (i = 0; i < paramNames.length; ++i) {
                    paramIndexMap.put(paramNames[i].toLowerCase(), i);
                }
                for (i = 0; i < fullParamNames.length; ++i) {
                    String paramLow = fullParamNames[i].toLowerCase();
                    if (paramIndexMap.containsKey(paramLow)) {
                        fullParamValues[i] = paramValues[(Integer)paramIndexMap.get(paramLow)];
                        continue;
                    }
                    KeyAndIndex keyAndIndex = BeanUtil.getKeyAndIndex(paramLow);
                    if (keyAndIndex == null || !paramIndexMap.containsKey(keyAndIndex.getKey())) continue;
                    fullParamValues[i] = BeanUtil.getArrayIndexValue(paramValues[(Integer)paramIndexMap.get(keyAndIndex.getKey())], keyAndIndex.getIndex());
                }
            }
        }
        if (filterAuthData) {
            QueryExecutorBuilder.dataAuthFilter(sqlToyContext.getUnifyFieldsHandler(), sqlToyConfig, fullParamNames, fullParamValues);
        }
        extend.paramsName = fullParamNames;
        extend.paramsValue = fullParamValues;
        IgnoreKeyCaseMap<String, Object> keyValueMap = new IgnoreKeyCaseMap<String, Object>();
        for (int i = 0; i < fullParamNames.length; ++i) {
            if (fullParamNames[i] == null) continue;
            keyValueMap.put(fullParamNames[i], fullParamValues[i]);
        }
        extend.tableShardingParams = QueryExecutorBuilder.getTableShardingParams(extend, sqlToyConfig);
        extend.tableShardingValues = QueryExecutorBuilder.wrapParamsValue(keyValueMap, extend.tableShardingParams);
        extend.dbShardingParams = QueryExecutorBuilder.getDbShardingParams(extend, sqlToyConfig);
        extend.dbShardingValues = QueryExecutorBuilder.wrapParamsValue(keyValueMap, extend.dbShardingParams);
    }

    private static void dataAuthFilter(IUnifyFieldsHandler unifyFieldsHandler, SqlToyConfig sqlToyConfig, String[] fullParamNames, Object[] fullParamValues) {
        IgnoreKeyCaseMap<String, DataAuthFilterConfig> authFilterMap;
        IgnoreKeyCaseMap<String, DataAuthFilterConfig> ignoreKeyCaseMap = authFilterMap = unifyFieldsHandler == null ? null : unifyFieldsHandler.dataAuthFilters();
        if (authFilterMap == null || authFilterMap.isEmpty()) {
            return;
        }
        for (int i = 0; i < fullParamNames.length; ++i) {
            String paramName = fullParamNames[i];
            if (!authFilterMap.containsKey(paramName)) continue;
            DataAuthFilterConfig dataAuthFilter = authFilterMap.get(paramName);
            if (StringUtil.isBlank(fullParamValues[i]) || QueryExecutorBuilder.equalChoiceAllValue(fullParamValues[i], dataAuthFilter.getChoiceAllValue())) {
                if (dataAuthFilter.getValues() == null) continue;
                fullParamValues[i] = dataAuthFilter.getValues();
                logger.debug("sqlId={} \u53c2\u6570:{} \u524d\u7aef\u672a\u4f20\u503c\uff0c\u7531\u5e73\u53f0\u7edf\u4e00\u5e26\u5165\u6388\u6743\u503c!", (Object)sqlToyConfig.getId(), (Object)paramName);
                continue;
            }
            if (dataAuthFilter.getValues() == null || !dataAuthFilter.isForcelimit()) continue;
            Object[] dataAuthed = dataAuthFilter.getValues().getClass().isArray() ? (Object[])dataAuthFilter.getValues() : (dataAuthFilter.getValues() instanceof Collection ? ((Collection)dataAuthFilter.getValues()).toArray() : new Object[]{dataAuthFilter.getValues()});
            HashSet<Object> authSet = new HashSet<Object>();
            for (Object item : dataAuthed) {
                if (item == null) continue;
                if (dataAuthFilter.isIgnoreType()) {
                    authSet.add(item.toString());
                    continue;
                }
                authSet.add(item);
            }
            Object[] pointValues = fullParamValues[i].getClass().isArray() ? (Object[])fullParamValues[i] : (fullParamValues[i] instanceof Collection ? ((Collection)fullParamValues[i]).toArray() : new Object[]{fullParamValues[i]});
            for (Object paramValue : pointValues) {
                if (paramValue == null || authSet.contains(dataAuthFilter.isIgnoreType() ? paramValue.toString() : paramValue)) continue;
                throw new DataAccessException("\u53c2\u6570:[" + paramName + "]\u53c2\u6570\u5bf9\u5e94\u7684\u503c:[" + paramValue + "] \u8d85\u51fa\u6388\u6743\u8303\u56f4(\u6570\u636e\u6765\u6e90\u53c2\u89c1spring.sqltoy.unifyFieldsHandler\u914d\u7f6e\u7684\u5b9e\u73b0),\u8bf7\u68c0\u67e5!");
            }
        }
    }

    private static String[] wrapFullParamNames(String[] paramNames, QueryExecutorExtend extend, SqlToyConfig sqlToyConfig) {
        ShardingStrategyConfig dbSharding;
        List<ShardingStrategyConfig> tableShardings;
        String key;
        HashSet<String> keys = new HashSet<String>();
        ArrayList<String> params = new ArrayList<String>();
        if (paramNames != null && paramNames.length > 0) {
            for (String item : paramNames) {
                key = item.toLowerCase();
                if (keys.contains(key)) continue;
                keys.add(key);
                params.add(item);
            }
        }
        if ((tableShardings = extend.tableShardings) == null || tableShardings.isEmpty()) {
            tableShardings = sqlToyConfig.getTableShardings();
        }
        if (tableShardings != null && tableShardings.size() > 0) {
            for (ShardingStrategyConfig shardingStrategy : tableShardings) {
                if (shardingStrategy.getFields() == null) continue;
                String[] stringArray = shardingStrategy.getFields();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String item = stringArray[i];
                    key = item.toLowerCase();
                    if (keys.contains(key)) continue;
                    keys.add(key);
                    params.add(item);
                }
            }
        }
        if ((dbSharding = extend.dbSharding) == null) {
            dbSharding = sqlToyConfig.getDataSourceSharding();
        }
        if (dbSharding != null && dbSharding.getFields() != null) {
            for (String item : dbSharding.getFields()) {
                key = item.toLowerCase();
                if (keys.contains(key)) continue;
                keys.add(key);
                params.add(item);
            }
        }
        if (params.isEmpty()) {
            return null;
        }
        return params.toArray(new String[params.size()]);
    }

    private static String[] getTableShardingParams(QueryExecutorExtend extend, SqlToyConfig sqlToyConfig) {
        HashSet<String> keys = new HashSet<String>();
        ArrayList<String> params = new ArrayList<String>();
        List<ShardingStrategyConfig> tableShardings = extend.tableShardings;
        if (tableShardings == null || tableShardings.isEmpty()) {
            tableShardings = sqlToyConfig.getTableShardings();
        }
        if (tableShardings != null && tableShardings.size() > 0) {
            for (ShardingStrategyConfig shardingStrategy : tableShardings) {
                if (shardingStrategy.getFields() == null) continue;
                for (String item : shardingStrategy.getFields()) {
                    String key = item.toLowerCase();
                    if (keys.contains(key)) continue;
                    keys.add(key);
                    params.add(item);
                }
            }
        }
        if (params.isEmpty()) {
            return null;
        }
        return params.toArray(new String[params.size()]);
    }

    private static String[] getDbShardingParams(QueryExecutorExtend extend, SqlToyConfig sqlToyConfig) {
        HashSet<String> keys = new HashSet<String>();
        ArrayList<String> params = new ArrayList<String>();
        ShardingStrategyConfig dbSharding = extend.dbSharding;
        if (dbSharding == null) {
            dbSharding = sqlToyConfig.getDataSourceSharding();
        }
        if (dbSharding != null && dbSharding.getFields() != null) {
            for (String item : dbSharding.getFields()) {
                String key = item.toLowerCase();
                if (keys.contains(key)) continue;
                keys.add(key);
                params.add(item);
            }
        }
        if (params.isEmpty()) {
            return null;
        }
        return params.toArray(new String[params.size()]);
    }

    private static Object[] wrapParamsValue(IgnoreKeyCaseMap<String, Object> keyValues, String[] wrapParaNames) {
        if (wrapParaNames == null || wrapParaNames.length == 0) {
            return null;
        }
        Object[] result = new Object[wrapParaNames.length];
        for (int i = 0; i < wrapParaNames.length; ++i) {
            result[i] = keyValues.get(wrapParaNames[i]);
        }
        return result;
    }

    private static boolean equalChoiceAllValue(Object paramValue, Object choiceAllValue) {
        if (choiceAllValue == null || paramValue == null) {
            return false;
        }
        Object[] pointValues = paramValue.getClass().isArray() ? (Object[])paramValue : (paramValue instanceof Collection ? ((Collection)paramValue).toArray() : new Object[]{paramValue});
        return pointValues.length == 1 && (choiceAllValue.equals(pointValues[0]) || choiceAllValue.toString().equals(pointValues[0].toString()));
    }

    private static boolean wrapParamNames(QueryExecutorExtend extend, SqlToyConfig sqlToyConfig, boolean wrapNamedArgs) {
        if (sqlToyConfig.isNamedParam() || extend.paramsName != null && extend.paramsName.length > 0) {
            return false;
        }
        int argCount = StringUtil.matchCnt(SqlConfigParseUtils.clearDblQuestMark(sqlToyConfig.getSql()), "\\?");
        if (argCount > 0) {
            int valuesSize;
            int n = valuesSize = extend.paramsValue == null ? 0 : extend.paramsValue.length;
            if (argCount == 1 && valuesSize > 1 && StringUtil.matches(sqlToyConfig.getSql(), SqlConfigParseUtils.IN_PATTERN)) {
                extend.paramsValue = new Object[]{extend.paramsValue};
                valuesSize = 1;
            }
            if (wrapNamedArgs) {
                if (argCount != valuesSize) {
                    throw new IllegalArgumentException("\u53c2\u6570\u503c\u6570\u91cf:" + valuesSize + " \u8ddfsql\u4e2d\u7684?\u6761\u4ef6\u6570\u91cf" + argCount + "\u4e0d\u5339\u914d,\u8bf7\u68c0\u67e5,\u5982\u662fjson\u6216sql\u4e2d\u5b58\u5728?\u7279\u6b8a\u5b57\u7b26\u4f46\u65e0\u5b9e\u9645\u6761\u4ef6\u53c2\u6570\u573a\u666f\uff0c\u53ef\u901a\u8fc7\u865a\u6784\u4e00\u4e2a\u6761\u4ef6\u53c2\u6570\u5982where #[1=:flag]\u89e3\u51b3!");
                }
                String[] paramsName = new String[argCount];
                for (int i = 0; i < argCount; ++i) {
                    paramsName[i] = SqlToyConstants.DEFAULT_PARAM_NAME + (i + 1);
                }
                extend.paramsName = paramsName;
                extend.wrappedParamNames = true;
            }
            return true;
        }
        return false;
    }
}

