/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.translate;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.model.IgnoreKeyCaseMap;
import org.sagacity.sqltoy.translate.TranslateFactory;
import org.sagacity.sqltoy.translate.cache.TranslateCacheManager;
import org.sagacity.sqltoy.translate.model.CacheCheckResult;
import org.sagacity.sqltoy.translate.model.CheckerConfigModel;
import org.sagacity.sqltoy.translate.model.TimeSection;
import org.sagacity.sqltoy.translate.model.TranslateConfigModel;
import org.sagacity.sqltoy.utils.DateUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheUpdateWatcher
extends Thread {
    private final Logger logger = LoggerFactory.getLogger(CacheUpdateWatcher.class);
    private ConcurrentHashMap<String, Long> lastCheckTime = new ConcurrentHashMap();
    private final String dateFmt = "yyyy-MM-dd HH:mm:ss";
    private CopyOnWriteArrayList<CheckerConfigModel> updateCheckers;
    private SqlToyContext sqlToyContext;
    private TranslateCacheManager translateCacheManager;
    private IgnoreKeyCaseMap<String, TranslateConfigModel> translateMap = null;
    private static int defaultIntervalSeconds = 15;
    private int delaySeconds = 30;
    private int deviationSeconds = 0;

    public CacheUpdateWatcher(SqlToyContext sqlToyContext, TranslateCacheManager translateCacheManager, IgnoreKeyCaseMap<String, TranslateConfigModel> translateMap, CopyOnWriteArrayList<CheckerConfigModel> updateCheckers, int delaySeconds, int deviationSeconds) {
        this.sqlToyContext = sqlToyContext;
        this.translateCacheManager = translateCacheManager;
        this.translateMap = translateMap;
        this.updateCheckers = updateCheckers;
        this.delaySeconds = delaySeconds;
        this.deviationSeconds = deviationSeconds;
    }

    @Override
    public void run() {
        try {
            if (this.delaySeconds >= 1) {
                Thread.sleep(1000 * this.delaySeconds);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        boolean isRun = true;
        while (isRun) {
            for (int i = 0; i < this.updateCheckers.size(); ++i) {
                CheckerConfigModel checkerConfig = this.updateCheckers.get(i);
                String checker = checkerConfig.getId();
                Long preCheck = this.lastCheckTime.get(checker);
                if (preCheck != null) {
                    long nowMillis = System.currentTimeMillis();
                    long nowInterval = (nowMillis - preCheck) / 1000L;
                    LocalDateTime ldt = LocalDateTime.now();
                    int hourMinutes = ldt.getHour() * 100 + ldt.getMinute();
                    long interval = this.getInterval(checkerConfig.getTimeSections(), hourMinutes);
                    if (nowInterval < interval) continue;
                    this.lastCheckTime.put(checker, DateUtil.parse(nowMillis, "yyyy-MM-dd HH:mm:ss").getTime());
                    this.doCheck(this.sqlToyContext, checkerConfig, DateUtil.addSecond(preCheck, this.deviationSeconds).getTime());
                    continue;
                }
                this.lastCheckTime.put(checker, System.currentTimeMillis());
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.logger.warn("\u7f13\u5b58\u7ffb\u8bd1\u68c0\u6d4b\u7f13\u5b58\u53d8\u66f4\u5f02\u5e38,\u68c0\u6d4b\u7ebf\u7a0b\u5c06\u7ec8\u6b62!{}", (Object)e.getMessage(), (Object)e);
                isRun = false;
            }
        }
    }

    private long getInterval(List<TimeSection> sections, int hourMinutes) {
        long interval = defaultIntervalSeconds;
        if (sections != null) {
            for (TimeSection section : sections) {
                if (hourMinutes < section.getStart() || hourMinutes >= section.getEnd()) continue;
                interval = section.getIntervalSeconds();
                break;
            }
        }
        return interval;
    }

    private void doCheck(SqlToyContext sqlToyContext, CheckerConfigModel checkerConfig, Long lastCheckTime) {
        if (!checkerConfig.isIncrement()) {
            List<CacheCheckResult> results = TranslateFactory.doCheck(sqlToyContext, checkerConfig, DateUtil.getTimestamp(lastCheckTime));
            if (results == null || results.isEmpty()) {
                return;
            }
            if (StringUtil.isNotBlank(checkerConfig.getCache())) {
                TranslateConfigModel translateConfig = this.translateMap.get(checkerConfig.getCache());
                this.logger.debug("\u68c0\u6d4b\u5230\u7f13\u5b58:{} \u53d1\u751f\u66f4\u65b0,\u5c06\u6e05\u9664\u7f13\u5b58\u4fbf\u4e8e\u540e\u7eed\u7f13\u5b58\u5168\u91cf\u66f4\u65b0!", (Object)translateConfig.getCache());
                this.translateCacheManager.clear(translateConfig.getCache(), null);
            } else {
                for (CacheCheckResult result : results) {
                    TranslateConfigModel translateConfig = this.translateMap.get(result.getCacheName());
                    if (translateConfig == null) continue;
                    this.logger.debug("\u68c0\u6d4b\u5230\u7f13\u5b58\u53d1\u751f\u66f4\u65b0: cacheName:{} cacheType:{}!", (Object)translateConfig.getCache(), (Object)(result.getCacheType() == null ? "\u65e0" : result.getCacheType()));
                    this.translateCacheManager.clear(translateConfig.getCache(), result.getCacheType());
                }
            }
        } else {
            TranslateConfigModel translateConfig = this.translateMap.get(checkerConfig.getCache());
            if (translateConfig == null) {
                return;
            }
            String cacheName = translateConfig.getCache();
            if (!this.translateCacheManager.hasCache(cacheName)) {
                return;
            }
            List<CacheCheckResult> results = TranslateFactory.doCheck(sqlToyContext, checkerConfig, DateUtil.getTimestamp(lastCheckTime));
            if (results == null || results.isEmpty()) {
                return;
            }
            this.logger.debug("\u68c0\u6d4b\u5230\u7f13\u5b58cacheName:{} \u53d1\u751f:{} \u6761\u8bb0\u5f55\u66f4\u65b0!", (Object)cacheName, (Object)results.size());
            int count = 0;
            try {
                if (!checkerConfig.isHasInsideGroup()) {
                    HashMap<String, Object[]> cacheData = this.translateCacheManager.getCache(cacheName, null);
                    for (CacheCheckResult result : results) {
                        if (result.getItem()[0] == null) continue;
                        cacheData.put(result.getItem()[0].toString(), result.getItem());
                        ++count;
                    }
                } else {
                    for (CacheCheckResult result : results) {
                        HashMap<String, Object[]> cacheData;
                        if (result.getItem()[0] == null || (cacheData = this.translateCacheManager.getCache(cacheName, result.getCacheType())) == null) continue;
                        cacheData.put(result.getItem()[0].toString(), result.getItem());
                        ++count;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error("\u7f13\u5b58\u589e\u91cf\u66f4\u65b0\u68c0\u6d4b,\u66f4\u65b0\u7f13\u5b58:{} \u53d1\u751f\u5f02\u5e38:{}", (Object)cacheName, (Object)e.getMessage());
            }
            this.logger.debug("\u7f13\u5b58\u5b9e\u9645\u5b8c\u6210:{} \u6761\u8bb0\u5f55\u66f4\u65b0!", (Object)count);
        }
    }
}

