/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.sagacity.sqltoy.SqlToyConstants;

public class Page<T>
implements Serializable {
    private static final long serialVersionUID = -7117473828519846708L;
    private int pageSize = SqlToyConstants.DEFAULT_PAGE_SIZE;
    private long pageNo = 1L;
    private List<T> rows;
    private Boolean skipQueryCount = false;
    private long recordCount;
    private long startIndex = 0L;
    private Boolean overPageToFirst;

    public Page() {
    }

    public Page(int pageSize, long pageNo) {
        if (pageSize > 0) {
            this.pageSize = pageSize;
        }
        this.pageNo = pageNo;
    }

    public Page(List<T> rows, long recordCount) {
        this.setPageSize(10);
        this.setRecordCount(recordCount);
        this.setRows(rows);
        this.startIndex = 0L;
    }

    public Page(List<T> rows, long recordCount, long startIndex) {
        this.setPageSize(10);
        this.setRecordCount(recordCount);
        this.setRows(rows);
        this.startIndex = startIndex;
    }

    public Page(List<T> rows, long recordCount, int pageSize, long startIndex) {
        this.setPageSize(pageSize);
        this.setRecordCount(recordCount);
        this.setRows(rows);
        this.startIndex = startIndex;
    }

    public List<T> getRows() {
        if (this.rows == null) {
            return new ArrayList();
        }
        return this.rows;
    }

    public Page setRows(List<T> rows) {
        this.rows = rows;
        return this;
    }

    public int getPageSize() {
        if (this.pageSize < 1) {
            return 10;
        }
        return this.pageSize;
    }

    public Page setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public long getRecordCount() {
        return this.recordCount;
    }

    public Page setRecordCount(long recordCount) {
        this.recordCount = recordCount < 0L ? 0L : recordCount;
        return this;
    }

    public Page setOverPageToFirst(Boolean overPageToFirst) {
        this.overPageToFirst = overPageToFirst;
        return this;
    }

    public long getPageNo() {
        if (this.pageNo == -1L) {
            return this.pageNo;
        }
        if (this.pageNo < 1L) {
            return 1L;
        }
        return this.pageNo;
    }

    public Page setPageNo(long pageNo) {
        this.pageNo = pageNo;
        return this;
    }

    public long getStartIndex() {
        if (this.startIndex == 0L && this.pageNo > 1L) {
            return (this.pageNo - 1L) * (long)this.pageSize;
        }
        return this.startIndex;
    }

    public long getNextIndex() {
        long nextIndex = this.getStartIndex() + (long)this.pageSize;
        if (nextIndex >= this.recordCount) {
            return this.getStartIndex();
        }
        return nextIndex;
    }

    public long getPreviousIndex() {
        long previousIndex = this.getStartIndex() - (long)this.pageSize;
        if (previousIndex < 0L) {
            return 0L;
        }
        return previousIndex;
    }

    public long getPriorPage() {
        if (this.pageNo > 1L) {
            return this.pageNo - 1L;
        }
        return this.pageNo;
    }

    public long getLastPage() {
        return (this.recordCount - 1L) / (long)this.getPageSize() + 1L;
    }

    public long getFirstPage() {
        return 1L;
    }

    public long getNextPage() {
        if (this.pageNo + 1L >= this.getLastPage()) {
            return this.getLastPage();
        }
        return this.pageNo + 1L;
    }

    public long getTotalPage() {
        if (this.pageSize < 1) {
            return 0L;
        }
        return (this.recordCount + (long)this.pageSize - 1L) / (long)this.pageSize;
    }

    public Boolean getSkipQueryCount() {
        return this.skipQueryCount;
    }

    public Page setSkipQueryCount(Boolean skipQueryCount) {
        this.skipQueryCount = skipQueryCount;
        return this;
    }

    public Boolean getOverPageToFirst() {
        return this.overPageToFirst;
    }
}

