/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.dialect.executor;

import java.util.concurrent.Callable;
import javax.sql.DataSource;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.dialect.DialectFactory;
import org.sagacity.sqltoy.model.ParallQuery;
import org.sagacity.sqltoy.model.ParallQueryResult;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.model.inner.ParallQueryExtend;
import org.sagacity.sqltoy.plugins.CrossDbAdapter;

public class ParallQueryExecutor
implements Callable<ParallQueryResult> {
    private SqlToyContext sqlToyContext;
    private DialectFactory dialectFactory;
    private DataSource dataSource;
    private ParallQuery parallQuery;
    private SqlToyConfig sqlToyConfig;
    private String[] paramNames;
    private Object[] paramValues;

    public ParallQueryExecutor(SqlToyContext sqlToyContext, DialectFactory dialectFactory, SqlToyConfig sqlToyConfig, ParallQuery parallQuery, String[] paramNames, Object[] paramValues, DataSource dataSource) {
        this.sqlToyContext = sqlToyContext;
        this.dialectFactory = dialectFactory;
        this.sqlToyConfig = sqlToyConfig;
        this.parallQuery = parallQuery;
        this.dataSource = dataSource;
        this.paramNames = paramNames;
        this.paramValues = paramValues;
    }

    @Override
    public ParallQueryResult call() {
        ParallQueryResult result = new ParallQueryResult();
        try {
            ParallQueryExtend extend = this.parallQuery.getExtend();
            QueryExecutor queryExecutor = new QueryExecutor(extend.sql).resultType(extend.resultType).names(this.paramNames).values(this.paramValues).showSql(extend.showSql);
            if (extend.page != null) {
                if (extend.page.getSkipQueryCount() != null && extend.page.getSkipQueryCount().booleanValue()) {
                    result.setResult(this.dialectFactory.findSkipTotalCountPage(this.sqlToyContext, queryExecutor, this.sqlToyConfig, extend.page.getPageNo(), extend.page.getPageSize(), this.dataSource));
                } else {
                    result.setResult(this.dialectFactory.findPage(this.sqlToyContext, queryExecutor, this.sqlToyConfig, extend.page.getPageNo(), extend.page.getPageSize(), extend.page.getOverPageToFirst(), this.dataSource));
                }
                CrossDbAdapter.redoPageQuery(this.sqlToyContext, this.dialectFactory, queryExecutor, extend.page);
            } else if (extend.topSize > 0.0) {
                result.setResult(this.dialectFactory.findTop(this.sqlToyContext, queryExecutor, this.sqlToyConfig, extend.topSize, this.dataSource));
                CrossDbAdapter.redoTopQuery(this.sqlToyContext, this.dialectFactory, queryExecutor, extend.topSize);
            } else if (extend.randomSize > 0.0) {
                result.setResult(this.dialectFactory.getRandomResult(this.sqlToyContext, queryExecutor, this.sqlToyConfig, extend.randomSize, this.dataSource));
                CrossDbAdapter.redoRandomQuery(this.sqlToyContext, this.dialectFactory, queryExecutor, extend.randomSize);
            } else {
                result.setResult(this.dialectFactory.findByQuery(this.sqlToyContext, queryExecutor, this.sqlToyConfig, null, this.dataSource));
                CrossDbAdapter.redoQuery(this.sqlToyContext, this.dialectFactory, queryExecutor);
            }
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setMessage(e.getMessage());
        }
        return result;
    }
}

