/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa.hibernate;

import com.mysema.codegen.CodeWriter;
import com.mysema.codegen.JavaWriter;
import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.query.QueryException;
import com.mysema.query.annotations.PropertyType;
import com.mysema.query.annotations.QueryInit;
import com.mysema.query.annotations.QueryType;
import com.mysema.query.codegen.CodegenModule;
import com.mysema.query.codegen.EmbeddableSerializer;
import com.mysema.query.codegen.EntitySerializer;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.Property;
import com.mysema.query.codegen.QueryTypeFactory;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.codegen.SerializerConfig;
import com.mysema.query.codegen.SimpleSerializerConfig;
import com.mysema.query.codegen.Supertype;
import com.mysema.query.codegen.SupertypeSerializer;
import com.mysema.query.codegen.TypeFactory;
import com.mysema.query.codegen.TypeMappings;
import com.mysema.query.jpa.hibernate.Constants;
import com.mysema.util.BeanUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.xml.stream.XMLStreamException;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateDomainExporter {
    private static final Logger logger = LoggerFactory.getLogger(HibernateDomainExporter.class);
    private final File targetFolder;
    private final Map<String, EntityType> allTypes = new HashMap<String, EntityType>();
    private final Map<String, EntityType> entityTypes = new HashMap<String, EntityType>();
    private final Map<String, EntityType> embeddableTypes = new HashMap<String, EntityType>();
    private final Map<String, EntityType> superTypes = new HashMap<String, EntityType>();
    private final Set<EntityType> serialized = new HashSet<EntityType>();
    private final TypeFactory typeFactory = new TypeFactory(new Class[0]);
    private final Configuration configuration;
    private final QueryTypeFactory queryTypeFactory;
    private final TypeMappings typeMappings;
    private final Serializer embeddableSerializer;
    private final Serializer entitySerializer;
    private final Serializer supertypeSerializer;
    private final SerializerConfig serializerConfig;

    public HibernateDomainExporter(File targetFolder, Configuration configuration) {
        this("Q", "", targetFolder, SimpleSerializerConfig.DEFAULT, configuration);
    }

    public HibernateDomainExporter(String namePrefix, File targetFolder, Configuration configuration) {
        this(namePrefix, "", targetFolder, SimpleSerializerConfig.DEFAULT, configuration);
    }

    public HibernateDomainExporter(String namePrefix, String nameSuffix, File targetFolder, Configuration configuration) {
        this(namePrefix, nameSuffix, targetFolder, SimpleSerializerConfig.DEFAULT, configuration);
    }

    public HibernateDomainExporter(String namePrefix, File targetFolder, SerializerConfig serializerConfig, Configuration configuration) {
        this(namePrefix, "", targetFolder, serializerConfig, configuration);
    }

    public HibernateDomainExporter(String namePrefix, String nameSuffix, File targetFolder, SerializerConfig serializerConfig, Configuration configuration) {
        this.targetFolder = targetFolder;
        this.serializerConfig = serializerConfig;
        this.configuration = configuration;
        CodegenModule module = new CodegenModule();
        module.bind("prefix", (Object)namePrefix);
        module.bind("suffix", (Object)nameSuffix);
        module.bind("keywords", Constants.keywords);
        this.queryTypeFactory = (QueryTypeFactory)module.get(QueryTypeFactory.class);
        this.typeMappings = (TypeMappings)module.get(TypeMappings.class);
        this.embeddableSerializer = (Serializer)module.get(EmbeddableSerializer.class);
        this.entitySerializer = (Serializer)module.get(EntitySerializer.class);
        this.supertypeSerializer = (Serializer)module.get(SupertypeSerializer.class);
        this.typeFactory.setUnknownAsEntity(true);
    }

    public void execute() throws IOException {
        try {
            this.collectTypes();
        }
        catch (SecurityException e) {
            throw new QueryException((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new QueryException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new QueryException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new QueryException((Throwable)e);
        }
        HashSet<EntityType> handled = new HashSet<EntityType>();
        for (EntityType type : this.superTypes.values()) {
            this.addSupertypeFields(type, this.allTypes, handled);
        }
        for (EntityType type : this.entityTypes.values()) {
            this.addSupertypeFields(type, this.allTypes, handled);
        }
        for (EntityType type : this.embeddableTypes.values()) {
            this.addSupertypeFields(type, this.allTypes, handled);
        }
        this.serialize(this.superTypes, this.supertypeSerializer);
        this.serialize(this.embeddableTypes, this.embeddableSerializer);
        this.serialize(this.entityTypes, this.entitySerializer);
    }

    private void addSupertypeFields(EntityType model, Map<String, EntityType> superTypes, Set<EntityType> handled) {
        if (handled.add(model)) {
            for (Supertype supertype : model.getSuperTypes()) {
                EntityType entityType = superTypes.get(supertype.getType().getFullName());
                if (entityType == null) continue;
                this.addSupertypeFields(entityType, superTypes, handled);
                supertype.setEntityType(entityType);
                model.include(supertype);
            }
        }
    }

    private void collectTypes() throws IOException, XMLStreamException, ClassNotFoundException, SecurityException, NoSuchMethodException {
        Iterator superClassMappings = this.configuration.getMappedSuperclassMappings();
        while (superClassMappings.hasNext()) {
            MappedSuperclass msc = (MappedSuperclass)superClassMappings.next();
            EntityType entityType = this.createSuperType(msc.getMappedClass());
            if (msc.getDeclaredIdentifierProperty() != null) {
                this.handleProperty(entityType, msc.getMappedClass(), msc.getDeclaredIdentifierProperty());
            }
            Iterator properties = msc.getDeclaredPropertyIterator();
            while (properties.hasNext()) {
                this.handleProperty(entityType, msc.getMappedClass(), (org.hibernate.mapping.Property)properties.next());
            }
        }
        Iterator classMappings = this.configuration.getClassMappings();
        while (classMappings.hasNext()) {
            PersistentClass pc = (PersistentClass)classMappings.next();
            EntityType entityType = this.createEntityType(pc.getMappedClass());
            if (pc.getDeclaredIdentifierProperty() != null) {
                this.handleProperty(entityType, pc.getMappedClass(), pc.getDeclaredIdentifierProperty());
            } else if (!pc.isInherited() && pc.hasIdentifierProperty()) {
                logger.info(entityType.toString() + pc.getIdentifierProperty());
                this.handleProperty(entityType, pc.getMappedClass(), pc.getIdentifierProperty());
            }
            Iterator properties = pc.getDeclaredPropertyIterator();
            while (properties.hasNext()) {
                this.handleProperty(entityType, pc.getMappedClass(), (org.hibernate.mapping.Property)properties.next());
            }
        }
    }

    private void handleProperty(EntityType entityType, Class<?> cl, org.hibernate.mapping.Property p) throws NoSuchMethodException, ClassNotFoundException {
        Type propertyType = this.getType(cl, p.getName());
        if (p.isComposite()) {
            Class<?> embeddedClass = Class.forName(propertyType.getFullName());
            EntityType embeddedType = this.createEmbeddableType(embeddedClass);
            Iterator properties = ((Component)p.getValue()).getPropertyIterator();
            while (properties.hasNext()) {
                this.handleProperty(embeddedType, embeddedClass, (org.hibernate.mapping.Property)properties.next());
            }
            propertyType = embeddedType;
        } else if (propertyType.getCategory() == TypeCategory.ENTITY) {
            propertyType = this.createEntityType(Class.forName(propertyType.getFullName()));
        }
        AnnotatedElement annotated = this.getAnnotatedElement(cl, p.getName());
        Property property = this.createProperty(entityType, p.getName(), propertyType, annotated);
        entityType.addProperty(property);
    }

    @Nullable
    private Property createProperty(EntityType entityType, String propertyName, Type propertyType, AnnotatedElement annotated) {
        String[] inits = new String[]{};
        if (annotated.isAnnotationPresent(QueryInit.class)) {
            inits = annotated.getAnnotation(QueryInit.class).value();
        }
        if (annotated.isAnnotationPresent(QueryType.class)) {
            QueryType queryType = annotated.getAnnotation(QueryType.class);
            if (queryType.value().equals((Object)PropertyType.NONE)) {
                return null;
            }
            propertyType = propertyType.as(queryType.value().getCategory());
        }
        return new Property(entityType, propertyName, propertyType, inits);
    }

    private EntityType createEntityType(Class<?> cl) {
        return this.createEntityType(cl, this.entityTypes);
    }

    private EntityType createEmbeddableType(Class<?> cl) {
        return this.createEntityType(cl, this.embeddableTypes);
    }

    private EntityType createEntityType(Class<?> cl, Map<String, EntityType> types) {
        if (types.containsKey(cl.getName())) {
            return types.get(cl.getName());
        }
        EntityType type = new EntityType((Type)new ClassType(TypeCategory.ENTITY, cl, new Type[0]));
        this.typeMappings.register((Type)type, this.queryTypeFactory.create((Type)type));
        if (!cl.getSuperclass().equals(Object.class)) {
            type.addSupertype(new Supertype((Type)new ClassType(cl.getSuperclass(), new Type[0])));
        }
        types.put(cl.getName(), type);
        this.allTypes.put(cl.getName(), type);
        return type;
    }

    private EntityType createSuperType(Class<?> cl) {
        return this.createEntityType(cl, this.superTypes);
    }

    private Type getType(Class<?> cl, String propertyName) throws NoSuchMethodException {
        try {
            Field field = cl.getDeclaredField(propertyName);
            return this.typeFactory.create(field.getType(), field.getGenericType());
        }
        catch (NoSuchFieldException e) {
            String getter = "get" + BeanUtils.capitalize((String)propertyName);
            String bgetter = "is" + BeanUtils.capitalize((String)propertyName);
            for (Method method : cl.getDeclaredMethods()) {
                if (!method.getName().equals(getter) && !method.getName().equals(bgetter) || method.getParameterTypes().length != 0) continue;
                return this.typeFactory.create(method.getReturnType(), method.getGenericReturnType());
            }
            if (cl.getSuperclass().equals(Object.class)) {
                throw new IllegalArgumentException("No property found for " + cl.getName() + "." + propertyName);
            }
            return this.getType(cl.getSuperclass(), propertyName);
        }
    }

    private AnnotatedElement getAnnotatedElement(Class<?> cl, String propertyName) throws NoSuchMethodException {
        try {
            return cl.getDeclaredField(propertyName);
        }
        catch (NoSuchFieldException e) {
            String getter = "get" + BeanUtils.capitalize((String)propertyName);
            String bgetter = "is" + BeanUtils.capitalize((String)propertyName);
            for (Method method : cl.getDeclaredMethods()) {
                if (!method.getName().equals(getter) && !method.getName().equals(bgetter) || method.getParameterTypes().length != 0) continue;
                return method;
            }
            if (cl.getSuperclass().equals(Object.class)) {
                throw new IllegalArgumentException("No property found for " + cl.getName() + "." + propertyName);
            }
            return this.getAnnotatedElement(cl.getSuperclass(), propertyName);
        }
    }

    private void serialize(Map<String, EntityType> types, Serializer serializer) throws IOException {
        for (EntityType entityType : types.values()) {
            if (!this.serialized.add(entityType)) continue;
            Type type = this.typeMappings.getPathType((Type)entityType, entityType, true);
            String packageName = type.getPackageName();
            String className = packageName.length() > 0 ? packageName + "." + type.getSimpleName() : type.getSimpleName();
            this.write(serializer, className.replace('.', '/') + ".java", entityType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Serializer serializer, String path, EntityType type) throws IOException {
        File targetFile = new File(this.targetFolder, path);
        Writer w = this.writerFor(targetFile);
        try {
            JavaWriter writer = new JavaWriter((Appendable)w);
            serializer.serialize(type, this.serializerConfig, (CodeWriter)writer);
        }
        finally {
            w.close();
        }
    }

    private Writer writerFor(File file) {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            logger.error("Folder " + file.getParent() + " could not be created");
        }
        try {
            return new OutputStreamWriter(new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

