/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa.impl;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.QueryException;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.SearchResults;
import com.mysema.query.jpa.HQLTemplates;
import com.mysema.query.jpa.JPQLQueryBase;
import com.mysema.query.jpa.JPQLTemplates;
import com.mysema.query.jpa.impl.DefaultSessionHolder;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.jpa.impl.JPASessionHolder;
import com.mysema.query.jpa.impl.JPAUtil;
import com.mysema.query.types.ConstructorExpression;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJPAQuery<Q extends AbstractJPAQuery<Q>>
extends JPQLQueryBase<Q> {
    private static final Logger logger = LoggerFactory.getLogger(JPAQuery.class);
    private final JPASessionHolder sessionHolder;
    private final Map<String, Object> hints = new HashMap<String, Object>();
    @Nullable
    private LockModeType lockMode;

    public AbstractJPAQuery(EntityManager em) {
        this(new DefaultSessionHolder(em), HQLTemplates.DEFAULT, (QueryMetadata)new DefaultQueryMetadata());
    }

    public AbstractJPAQuery(JPASessionHolder sessionHolder, JPQLTemplates patterns, QueryMetadata metadata) {
        super(metadata, patterns);
        this.sessionHolder = sessionHolder;
    }

    public long count() {
        String queryString = this.toCountRowsString();
        this.logQuery(queryString);
        Query query = this.createQuery(queryString, null);
        this.reset();
        return (Long)query.getSingleResult();
    }

    public Query createQuery(Expression<?> expr) {
        this.getQueryMixin().addToProjection(new Expression[]{expr});
        String queryString = this.toString();
        this.logQuery(queryString);
        return this.createQuery(queryString, this.getMetadata().getModifiers());
    }

    public Query createQuery(Expression<?> expr1, Expression<?> expr2, Expression<?> ... rest) {
        this.getQueryMixin().addToProjection(new Expression[]{expr1, expr2});
        this.getQueryMixin().addToProjection(rest);
        String queryString = this.toString();
        this.logQuery(queryString);
        return this.createQuery(queryString, this.getMetadata().getModifiers());
    }

    public Query createQuery(Expression<?>[] args) {
        this.getQueryMixin().addToProjection(args);
        String queryString = this.toString();
        this.logQuery(queryString);
        return this.createQuery(queryString, this.getMetadata().getModifiers());
    }

    private Query createQuery(String queryString, @Nullable QueryModifiers modifiers) {
        Expression expr;
        Query query = this.sessionHolder.createQuery(queryString);
        JPAUtil.setConstants(query, this.getConstants(), this.getMetadata().getParams());
        if (modifiers != null && modifiers.isRestricting()) {
            if (modifiers.getLimit() != null) {
                query.setMaxResults(modifiers.getLimit().intValue());
            }
            if (modifiers.getOffset() != null) {
                query.setFirstResult(modifiers.getOffset().intValue());
            }
        }
        if (this.lockMode != null) {
            query.setLockMode(this.lockMode);
        }
        for (Map.Entry<String, Object> entry : this.hints.entrySet()) {
            query.setHint(entry.getKey(), entry.getValue());
        }
        List projection = this.getMetadata().getProjection();
        if (projection.size() == 1 && (expr = (Expression)projection.get(0)) instanceof FactoryExpression && !(expr instanceof ConstructorExpression) && query.getClass().getName().startsWith("org.hibernate")) {
            try {
                Class<?> cl = Class.forName("com.mysema.query.jpa.impl.JPAQueryTransformerTask");
                cl.getConstructor(Query.class, FactoryExpression.class).newInstance(query, expr);
            }
            catch (ClassNotFoundException e) {
                throw new QueryException(e.getMessage(), (Throwable)e);
            }
            catch (SecurityException e) {
                throw new QueryException(e.getMessage(), (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new QueryException(e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new QueryException(e.getMessage(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new QueryException(e.getMessage(), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new QueryException(e.getMessage(), (Throwable)e);
            }
        }
        return query;
    }

    public CloseableIterator<Object[]> iterate(Expression<?>[] args) {
        return new IteratorAdapter(this.list(args).iterator());
    }

    public <RT> CloseableIterator<RT> iterate(Expression<RT> projection) {
        return new IteratorAdapter(this.list(projection).iterator());
    }

    public List<Object[]> list(Expression<?>[] args) {
        Query query = this.createQuery(args);
        this.reset();
        return query.getResultList();
    }

    public <RT> List<RT> list(Expression<RT> expr) {
        Query query = this.createQuery(expr);
        this.reset();
        return query.getResultList();
    }

    public <RT> SearchResults<RT> listResults(Expression<RT> expr) {
        this.getQueryMixin().addToProjection(new Expression[]{expr});
        Query query = this.createQuery(this.toCountRowsString(), null);
        long total = (Long)query.getSingleResult();
        if (total > 0L) {
            QueryModifiers modifiers = this.getMetadata().getModifiers();
            String queryString = this.toString();
            this.logQuery(queryString);
            query = this.createQuery(queryString, modifiers);
            List list = query.getResultList();
            this.reset();
            return new SearchResults(list, modifiers, total);
        }
        this.reset();
        return SearchResults.emptyResults();
    }

    protected void logQuery(String queryString) {
        if (logger.isDebugEnabled()) {
            logger.debug(queryString.replace('\n', ' '));
        }
    }

    public <RT> RT uniqueResult(Expression<RT> expr) {
        this.getQueryMixin().addToProjection(new Expression[]{expr});
        String queryString = this.toQueryString();
        this.logQuery(queryString);
        Query query = this.createQuery(queryString, null);
        this.reset();
        try {
            return (RT)query.getSingleResult();
        }
        catch (NoResultException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Q setLockMode(LockModeType lockMode) {
        this.lockMode = lockMode;
        return (Q)((Object)this);
    }

    public Q setHint(String name, Object value) {
        this.hints.put(name, value);
        return (Q)((Object)this);
    }
}

