/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa.hibernate;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.QueryException;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.SearchResults;
import com.mysema.query.jpa.HQLTemplates;
import com.mysema.query.jpa.JPQLQueryBase;
import com.mysema.query.jpa.JPQLTemplates;
import com.mysema.query.jpa.hibernate.DefaultSessionHolder;
import com.mysema.query.jpa.hibernate.FactoryExpressionTransformer;
import com.mysema.query.jpa.hibernate.HibernateQuery;
import com.mysema.query.jpa.hibernate.HibernateUtil;
import com.mysema.query.jpa.hibernate.SessionHolder;
import com.mysema.query.types.ConstructorExpression;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.transform.ResultTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHibernateQuery<Q extends AbstractHibernateQuery<Q>>
extends JPQLQueryBase<Q> {
    private static final Logger logger = LoggerFactory.getLogger(HibernateQuery.class);
    private Boolean cacheable;
    private Boolean readOnly;
    private String cacheRegion;
    private int fetchSize = 0;
    private final Map<Path<?>, LockMode> lockModes = new HashMap();
    private final SessionHolder session;
    private int timeout = 0;

    public AbstractHibernateQuery(Session session) {
        this(new DefaultSessionHolder(session), HQLTemplates.DEFAULT, (QueryMetadata)new DefaultQueryMetadata());
    }

    public AbstractHibernateQuery(SessionHolder session, JPQLTemplates patterns, QueryMetadata metadata) {
        super(metadata, patterns);
        this.session = session;
    }

    public long count() {
        QueryModifiers modifiers = this.getMetadata().getModifiers();
        String queryString = this.toCountRowsString();
        this.logQuery(queryString);
        Query query = this.createQuery(queryString, modifiers);
        this.reset();
        Long rv = (Long)query.uniqueResult();
        if (rv != null) {
            return rv;
        }
        throw new QueryException("Query returned null");
    }

    public Query createQuery(Expression<?> expr) {
        this.getQueryMixin().addToProjection(new Expression[]{expr});
        String queryString = this.toQueryString();
        return this.createQuery(queryString, this.getMetadata().getModifiers());
    }

    public Query createQuery(Expression<?> expr1, Expression<?> expr2, Expression<?> ... rest) {
        this.getQueryMixin().addToProjection(new Expression[]{expr1, expr2});
        this.getQueryMixin().addToProjection(rest);
        String queryString = this.toQueryString();
        this.logQuery(queryString);
        return this.createQuery(queryString, this.getMetadata().getModifiers());
    }

    public Query createQuery(Expression<?>[] args) {
        this.getQueryMixin().addToProjection(args);
        String queryString = this.toQueryString();
        this.logQuery(queryString);
        return this.createQuery(queryString, this.getMetadata().getModifiers());
    }

    private Query createQuery(String queryString, @Nullable QueryModifiers modifiers) {
        Expression expr;
        List projection;
        Query query = this.session.createQuery(queryString);
        HibernateUtil.setConstants(query, this.getConstants(), this.getMetadata().getParams());
        if (this.fetchSize > 0) {
            query.setFetchSize(this.fetchSize);
        }
        if (this.timeout > 0) {
            query.setTimeout(this.timeout);
        }
        if (this.cacheable != null) {
            query.setCacheable(this.cacheable.booleanValue());
        }
        if (this.cacheRegion != null) {
            query.setCacheRegion(this.cacheRegion);
        }
        if (this.readOnly != null) {
            query.setReadOnly(this.readOnly.booleanValue());
        }
        for (Map.Entry<Path<?>, LockMode> entry : this.lockModes.entrySet()) {
            query.setLockMode(entry.getKey().toString(), entry.getValue());
        }
        if (modifiers != null && modifiers.isRestricting()) {
            if (modifiers.getLimit() != null) {
                query.setMaxResults(modifiers.getLimit().intValue());
            }
            if (modifiers.getOffset() != null) {
                query.setFirstResult(modifiers.getOffset().intValue());
            }
        }
        if ((projection = this.getMetadata().getProjection()).size() == 1 && (expr = (Expression)projection.get(0)) instanceof FactoryExpression && !(expr instanceof ConstructorExpression)) {
            query.setResultTransformer((ResultTransformer)new FactoryExpressionTransformer((FactoryExpression)projection.get(0)));
        }
        return query;
    }

    public CloseableIterator<Object[]> iterate(Expression<?>[] args) {
        Query query = this.createQuery(args);
        this.reset();
        return new IteratorAdapter(query.iterate());
    }

    public <RT> CloseableIterator<RT> iterate(Expression<RT> projection) {
        Query query = this.createQuery(projection);
        this.reset();
        return new IteratorAdapter(query.iterate());
    }

    public List<Object[]> list(Expression<?>[] args) {
        Query query = this.createQuery(args);
        this.reset();
        return query.list();
    }

    public <RT> List<RT> list(Expression<RT> expr) {
        Query query = this.createQuery(expr);
        this.reset();
        return query.list();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RT> SearchResults<RT> listResults(Expression<RT> expr) {
        this.getQueryMixin().addToProjection(new Expression[]{expr});
        Query query = this.createQuery(this.toCountRowsString(), null);
        long total = (Long)query.uniqueResult();
        try {
            if (total > 0L) {
                QueryModifiers modifiers = this.getMetadata().getModifiers();
                String queryString = this.toQueryString();
                this.logQuery(queryString);
                query = this.createQuery(queryString, modifiers);
                List list = query.list();
                SearchResults searchResults = new SearchResults(list, modifiers, total);
                return searchResults;
            }
            SearchResults searchResults = SearchResults.emptyResults();
            return searchResults;
        }
        finally {
            this.reset();
        }
    }

    protected void logQuery(String queryString) {
        if (logger.isDebugEnabled()) {
            logger.debug(queryString.replace('\n', ' '));
        }
    }

    public ScrollableResults scroll(ScrollMode mode, Expression<?> expr) {
        Query query = this.createQuery(expr);
        this.reset();
        return query.scroll(mode);
    }

    public ScrollableResults scroll(ScrollMode mode, Expression<?> expr1, Expression<?> expr2, Expression<?> ... rest) {
        Query query = this.createQuery(expr1, expr2, rest);
        this.reset();
        return query.scroll(mode);
    }

    public ScrollableResults scroll(ScrollMode mode, Expression<?>[] args) {
        Query query = this.createQuery(args);
        this.reset();
        return query.scroll(mode);
    }

    public Q setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return (Q)((Object)this);
    }

    public Q setCacheRegion(String cacheRegion) {
        this.cacheRegion = cacheRegion;
        return (Q)((Object)this);
    }

    public Q setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return (Q)((Object)this);
    }

    public Q setLockMode(Path<?> path, LockMode lockMode) {
        this.lockModes.put(path, lockMode);
        return (Q)((Object)this);
    }

    public Q setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return (Q)((Object)this);
    }

    public Q setTimeout(int timeout) {
        this.timeout = timeout;
        return (Q)((Object)this);
    }

    public <RT> RT uniqueResult(Expression<RT> expr) {
        this.getQueryMixin().addToProjection(new Expression[]{expr});
        QueryModifiers modifiers = this.getMetadata().getModifiers();
        String queryString = this.toQueryString();
        this.logQuery(queryString);
        Query query = this.createQuery(queryString, modifiers);
        this.reset();
        return (RT)query.uniqueResult();
    }
}

