/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt;

import com.mysema.codegen.CodeWriter;
import com.mysema.codegen.JavaWriter;
import com.mysema.codegen.model.Parameter;
import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.commons.lang.Assert;
import com.mysema.query.annotations.QueryDelegate;
import com.mysema.query.annotations.QueryExclude;
import com.mysema.query.annotations.QueryProjection;
import com.mysema.query.annotations.Variables;
import com.mysema.query.apt.Configuration;
import com.mysema.query.apt.ExtendedTypeFactory;
import com.mysema.query.apt.TypeElementHandler;
import com.mysema.query.apt.TypeExtractor;
import com.mysema.query.apt.VisitorConfig;
import com.mysema.query.codegen.Delegate;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.Property;
import com.mysema.query.codegen.QueryTypeFactory;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.codegen.SerializerConfig;
import com.mysema.query.codegen.Supertype;
import com.mysema.query.codegen.TypeMappings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class Processor {
    static final Map<Class<? extends Annotation>, Set<Element>> elementCache = Collections.synchronizedMap(new HashMap());
    private final Map<String, Set<TypeElement>> typeElements = new HashMap<String, Set<TypeElement>>();
    private final Set<Class<? extends Annotation>> entityAnnotations = new HashSet<Class<? extends Annotation>>();
    private final Map<String, EntityType> actualSupertypes = new HashMap<String, EntityType>();
    private final Map<String, EntityType> allSupertypes = new HashMap<String, EntityType>();
    private final Configuration configuration;
    private final Map<String, EntityType> projectionTypes = new HashMap<String, EntityType>();
    private final TypeElementHandler elementHandler;
    private final Map<String, EntityType> embeddables = new HashMap<String, EntityType>();
    private final Map<String, EntityType> entityTypes = new HashMap<String, EntityType>();
    private final ProcessingEnvironment env;
    private final Map<String, EntityType> extensionTypes = new HashMap<String, EntityType>();
    private final RoundEnvironment roundEnv;
    private final ExtendedTypeFactory typeFactory;
    private final TypeExtractor typeExtractor = new TypeExtractor(true);

    public Processor(ProcessingEnvironment env, RoundEnvironment roundEnv, Configuration configuration) {
        this.env = (ProcessingEnvironment)Assert.notNull((Object)env, (String)"env");
        this.roundEnv = (RoundEnvironment)Assert.notNull((Object)roundEnv, (String)"roundEnv");
        this.configuration = (Configuration)Assert.notNull((Object)configuration, (String)"configuration");
        this.entityAnnotations.add(configuration.getEntityAnnotation());
        if (configuration.getSuperTypeAnnotation() != null) {
            this.entityAnnotations.add(configuration.getSuperTypeAnnotation());
        }
        if (configuration.getEmbeddableAnnotation() != null) {
            this.entityAnnotations.add(configuration.getEmbeddableAnnotation());
        }
        TypeMappings typeMappings = configuration.getTypeMappings();
        QueryTypeFactory queryTypeFactory = configuration.getQueryTypeFactory();
        this.typeFactory = new ExtendedTypeFactory(env, configuration, this.entityAnnotations, typeMappings, queryTypeFactory);
        this.elementHandler = new TypeElementHandler(configuration, this.typeFactory, typeMappings, queryTypeFactory);
    }

    public void process() {
        this.processAnnotations();
        for (String key : this.actualSupertypes.keySet()) {
            this.entityTypes.remove(key);
            this.extensionTypes.remove(key);
            this.embeddables.remove(key);
        }
        for (String key : this.entityTypes.keySet()) {
            this.actualSupertypes.remove(key);
            this.extensionTypes.remove(key);
            this.embeddables.remove(key);
        }
        this.serializeTypes();
        this.serializeVariableClasses();
    }

    private void processAnnotations() {
        boolean hasEmbeddableAnnotation;
        this.processExclusions();
        this.processDelegateMethods();
        if (this.configuration.isUnknownAsEmbedded()) {
            this.env.getMessager().printMessage(Diagnostic.Kind.NOTE, "Collecting custom types");
            this.processFromProperties();
        }
        boolean bl = hasEmbeddableAnnotation = this.configuration.getEmbeddableAnnotation() != null;
        if (this.configuration.getSuperTypeAnnotation() != null) {
            this.process(this.configuration.getSuperTypeAnnotation(), hasEmbeddableAnnotation, this.actualSupertypes);
        }
        if (this.configuration.getEmbeddedAnnotation() != null) {
            this.processEmbedded();
        }
        if (this.configuration.getEmbeddableAnnotation() != null) {
            this.process(this.configuration.getEmbeddableAnnotation(), false, this.embeddables);
        }
        if (this.configuration.getEntitiesAnnotation() != null) {
            this.processEntitiesFromPackage();
        }
        this.process(this.configuration.getEntityAnnotation(), hasEmbeddableAnnotation, this.entityTypes);
        this.processProjectionTypes();
    }

    private Set<? extends Element> getElements(Class<? extends Annotation> a) {
        return this.roundEnv.getElementsAnnotatedWith(a);
    }

    private void processExclusions() {
        for (Element element : this.getElements(QueryExclude.class)) {
            if (element instanceof PackageElement) {
                this.configuration.addExcludedPackage(((PackageElement)element).getQualifiedName().toString());
                continue;
            }
            if (element instanceof TypeElement) {
                this.configuration.addExcludedClass(((TypeElement)element).getQualifiedName().toString());
                continue;
            }
            throw new IllegalArgumentException(element.toString());
        }
    }

    private void process(Class<? extends Annotation> annotation, boolean skipEmbeddables, Map<String, EntityType> types) {
        this.process(this.getElements(annotation), skipEmbeddables, types);
    }

    private void process(Set<? extends Element> elements, boolean skipEmbeddables, Map<String, EntityType> types) {
        ArrayDeque<Type> superTypes = new ArrayDeque<Type>();
        ArrayList<TypeElement> allElements = new ArrayList<TypeElement>();
        ArrayList<TypeMirror> typeMirrors = new ArrayList<TypeMirror>();
        ArrayList<TypeMirror> superTypeMirrors = new ArrayList<TypeMirror>();
        for (TypeElement typeElement : elements) {
            if (skipEmbeddables && typeElement.getAnnotation(this.configuration.getEmbeddableAnnotation()) != null) continue;
            this.typeFactory.getEntityType(typeElement.asType(), false);
            typeMirrors.add(typeElement.asType());
            allElements.add(typeElement);
            this.addAnnotationlessSupertypes(superTypeMirrors, allElements, typeElement);
        }
        for (TypeMirror typeMirror : superTypeMirrors) {
            this.typeFactory.getEntityType(typeMirror, true);
        }
        for (TypeMirror typeMirror : typeMirrors) {
            this.typeFactory.getEntityType(typeMirror, true);
        }
        for (TypeElement typeElement : allElements) {
            EntityType model = this.elementHandler.handleEntityType(typeElement);
            this.registerTypeElement(model.getFullName(), typeElement);
            types.put(model.getFullName(), model);
            if (model.getSuperType() == null) continue;
            superTypes.push(model.getSuperType().getType());
        }
        this.mergeTypes(types, superTypes);
    }

    private void processEmbedded() {
        HashSet<TypeElement> elements = new HashSet<TypeElement>();
        for (Element element : this.getElements(this.configuration.getEmbeddedAnnotation())) {
            TypeElement typeElement;
            String typeName;
            TypeMirror type = element.asType();
            if (element.getKind() == ElementKind.METHOD) {
                type = ((ExecutableElement)element).getReturnType();
            }
            if ((typeName = ((Object)type).toString()).startsWith(Collection.class.getName()) || typeName.startsWith(List.class.getName()) || typeName.startsWith(Set.class.getName())) {
                type = ((DeclaredType)type).getTypeArguments().get(0);
            } else if (typeName.startsWith(Map.class.getName())) {
                type = ((DeclaredType)type).getTypeArguments().get(1);
            }
            if ((typeElement = (TypeElement)this.typeExtractor.visit(type)) == null || typeElement.getAnnotation(this.configuration.getEntityAnnotation()) != null) continue;
            elements.add(typeElement);
        }
        this.process(elements, false, this.embeddables);
    }

    private void processEntitiesFromPackage() {
        Class<? extends Annotation> annotation = this.configuration.getEntitiesAnnotation();
        HashSet<Element> elements = new HashSet<Element>();
        for (Element element : this.getElements(annotation)) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().asElement().getSimpleName().toString().equals(annotation.getSimpleName())) continue;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    if (!entry.getKey().getSimpleName().toString().equals("value")) continue;
                    List values = (List)entry.getValue().getValue();
                    for (AnnotationValue value : values) {
                        DeclaredType type = (DeclaredType)value.getValue();
                        elements.add(type.asElement());
                    }
                }
            }
        }
        this.process(elements, false, this.entityTypes);
    }

    private void processFromProperties() {
        HashSet<? extends Element> elements = new HashSet<Element>();
        for (Class<? extends Annotation> annotation : this.entityAnnotations) {
            elements.addAll(this.getElements(annotation));
        }
        HashSet<TypeElement> types = new HashSet<TypeElement>();
        for (Element element : elements) {
            if (!(element instanceof TypeElement)) continue;
            this.processFromProperties((TypeElement)element, types);
        }
        ArrayList<TypeMirror> typeMirrors = new ArrayList<TypeMirror>(types.size());
        for (TypeElement type : types) {
            if (type.getQualifiedName().toString().startsWith("java.")) continue;
            boolean annotated = false;
            for (Class<? extends Annotation> annotation : this.entityAnnotations) {
                annotated |= type.getAnnotation(annotation) != null;
            }
            if (annotated) continue;
            this.typeFactory.getEntityType(type.asType(), false);
            typeMirrors.add(type.asType());
        }
        for (TypeMirror typeMirror : typeMirrors) {
            this.typeFactory.getEntityType(typeMirror, true);
        }
        for (TypeElement element : types) {
            if (!typeMirrors.contains(element.asType())) continue;
            EntityType model = this.elementHandler.handleEntityType(element);
            this.registerTypeElement(model.getFullName(), element);
            this.embeddables.put(model.getFullName(), model);
        }
        if (this.configuration.getEmbeddableAnnotation() == null) {
            this.allSupertypes.putAll(this.embeddables);
            HashSet<EntityType> hashSet = new HashSet<EntityType>();
            for (EntityType embeddable : this.embeddables.values()) {
                this.addSupertypeFields(embeddable, this.allSupertypes, hashSet);
            }
        }
    }

    private void processFromProperties(TypeElement type, Set<TypeElement> types) {
        List<? extends Element> children = type.getEnclosedElements();
        VisitorConfig config = this.configuration.getConfig(type, children);
        if (config.visitFieldProperties()) {
            for (VariableElement field : ElementFilter.fieldsIn(children)) {
                TypeElement typeElement = (TypeElement)this.typeExtractor.visit(field.asType());
                if (typeElement == null) continue;
                types.add(typeElement);
            }
        }
        if (config.visitMethodProperties()) {
            for (ExecutableElement method : ElementFilter.methodsIn(children)) {
                TypeElement typeElement;
                String name = method.getSimpleName().toString();
                if (!name.startsWith("get") && !name.startsWith("is") || !method.getParameters().isEmpty() || (typeElement = (TypeElement)this.typeExtractor.visit(method.getReturnType())) == null) continue;
                types.add(typeElement);
            }
        }
    }

    private void addSupertypeFields(EntityType model, Map<String, EntityType> superTypes, Set<EntityType> handled) {
        if (handled.add(model)) {
            for (Supertype supertype : model.getSuperTypes()) {
                EntityType entityType = superTypes.get(supertype.getType().getFullName());
                if (entityType == null) continue;
                this.addSupertypeFields(entityType, superTypes, handled);
                supertype.setEntityType(entityType);
                model.include(supertype);
            }
        }
    }

    private Set<Element> getElementsAndCache(Class<? extends Annotation> annotationType) {
        Set<Element> elements = this.getElements(annotationType);
        if (!elements.isEmpty()) {
            Set<Element> cached = elementCache.get(annotationType);
            if (cached == null) {
                cached = new HashSet<Element>();
                elementCache.put(annotationType, cached);
            }
            cached.addAll(elements);
        }
        return elements;
    }

    private Set<Element> getElementsFromCache(Class<? extends Annotation> annotationType) {
        Set<Element> cached = elementCache.get(annotationType);
        if (cached != null) {
            HashSet<Element> cloned = new HashSet<Element>();
            for (Element element : cached) {
                if (element instanceof TypeElement) {
                    cloned.add(this.env.getElementUtils().getTypeElement(((TypeElement)element).getQualifiedName().toString()));
                    continue;
                }
                Element parent = element.getEnclosingElement();
                if (parent instanceof TypeElement) {
                    parent = this.env.getElementUtils().getTypeElement(((TypeElement)parent).getQualifiedName().toString());
                    for (Element element2 : parent.getEnclosedElements()) {
                        if (element2.getKind() != element.getKind() || !((Object)element2.getSimpleName()).equals(element.getSimpleName())) continue;
                        cloned.add(element2);
                    }
                    continue;
                }
                this.env.getMessager().printMessage(Diagnostic.Kind.WARNING, element + " from cache");
                cloned.add(element);
            }
            return cloned;
        }
        return Collections.emptySet();
    }

    private void mergeTypes(Map<String, EntityType> types, Deque<Type> superTypes) {
        while (!superTypes.isEmpty()) {
            Type superType = superTypes.pop();
            if (types.containsKey(superType.getFullName()) || this.allSupertypes.containsKey(superType.getFullName())) continue;
            TypeElement typeElement = this.env.getElementUtils().getTypeElement(superType.getFullName());
            if (typeElement == null) {
                throw new IllegalStateException("Found no type for " + superType.getFullName());
            }
            EntityType entityType = this.elementHandler.handleEntityType(typeElement);
            if (entityType.getSuperType() != null) {
                superTypes.push(entityType.getSuperType().getType());
            }
            this.allSupertypes.put(superType.getFullName(), entityType);
        }
        this.allSupertypes.putAll(types);
        HashSet<EntityType> handled = new HashSet<EntityType>();
        for (EntityType type : types.values()) {
            this.addSupertypeFields(type, this.allSupertypes, handled);
        }
    }

    private boolean hasKnownAnnotation(Element element) {
        if (this.configuration.getEmbeddableAnnotation() != null && element.getAnnotation(this.configuration.getEmbeddableAnnotation()) != null) {
            return true;
        }
        if (this.configuration.getSuperTypeAnnotation() != null && element.getAnnotation(this.configuration.getSuperTypeAnnotation()) != null) {
            return true;
        }
        return element.getAnnotation(this.configuration.getEntityAnnotation()) != null;
    }

    private void processDelegateMethod(Element delegateMethod, boolean cached) {
        ExecutableElement method = (ExecutableElement)delegateMethod;
        Element element = delegateMethod.getEnclosingElement();
        String name = method.getSimpleName().toString();
        Type delegateType = this.typeFactory.getType(element.asType(), true);
        Type returnType = this.typeFactory.getType(method.getReturnType(), true);
        List<Parameter> parameters = this.elementHandler.transformParams(method.getParameters());
        parameters = parameters.subList(1, parameters.size());
        EntityType entityType = null;
        for (AnnotationMirror annotationMirror : delegateMethod.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().asElement().getSimpleName().toString().equals(QueryDelegate.class.getSimpleName())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!entry.getKey().getSimpleName().toString().equals("value") || !(entry.getValue().getValue() instanceof TypeMirror)) continue;
                TypeMirror type = (TypeMirror)entry.getValue().getValue();
                entityType = this.typeFactory.getEntityType(type, true);
            }
        }
        if (entityType != null) {
            this.registerTypeElement(entityType.getFullName(), (TypeElement)element);
            entityType.addDelegate(new Delegate(entityType, delegateType, name, parameters, returnType));
            if (!cached) {
                this.extensionTypes.put(entityType.getFullName(), entityType);
            }
        }
    }

    private void processDelegateMethods() {
        for (Element delegateMethod : this.getElementsFromCache(QueryDelegate.class)) {
            this.processDelegateMethod(delegateMethod, true);
        }
        for (Element delegateMethod : this.getElementsAndCache(QueryDelegate.class)) {
            this.processDelegateMethod(delegateMethod, false);
        }
    }

    private void processProjectionTypes() {
        HashSet<Element> visitedDTOTypes = new HashSet<Element>();
        for (Element element : this.getElements(QueryProjection.class)) {
            Element parent = element.getEnclosingElement();
            if (parent.getAnnotation(this.configuration.getEntityAnnotation()) != null || parent.getAnnotation(this.configuration.getEmbeddableAnnotation()) != null || visitedDTOTypes.contains(parent)) continue;
            EntityType model = this.elementHandler.handleProjectionType((TypeElement)parent);
            this.registerTypeElement(model.getFullName(), (TypeElement)parent);
            this.projectionTypes.put(model.getFullName(), model);
            visitedDTOTypes.add(parent);
        }
    }

    private void addAnnotationlessSupertypes(List<TypeMirror> superTypeMirrors, List<TypeElement> elements, TypeElement element) {
        TypeMirror superTypeMirror = element.getSuperclass();
        while (superTypeMirror != null) {
            TypeElement superTypeElement = (TypeElement)this.env.getTypeUtils().asElement(superTypeMirror);
            if (superTypeElement != null && !superTypeElement.toString().startsWith("java.lang.") && !this.hasKnownAnnotation(superTypeElement)) {
                this.typeFactory.getEntityType(superTypeMirror, false);
                superTypeMirrors.add(superTypeMirror);
                elements.add(superTypeElement);
                superTypeMirror = superTypeElement.getSuperclass();
                if (!(superTypeMirror instanceof NoType)) continue;
                superTypeMirror = null;
                continue;
            }
            superTypeMirror = null;
        }
    }

    private void registerTypeElement(String entityName, TypeElement element) {
        Set<TypeElement> elements = this.typeElements.get(entityName);
        if (elements == null) {
            elements = new HashSet<TypeElement>();
            this.typeElements.put(entityName, elements);
        }
        elements.add(element);
    }

    private void serializeTypes() {
        if (!this.actualSupertypes.isEmpty()) {
            this.env.getMessager().printMessage(Diagnostic.Kind.NOTE, "Serializing Supertypes");
            this.serialize(this.configuration.getSupertypeSerializer(), this.actualSupertypes.values());
        }
        if (!this.entityTypes.isEmpty()) {
            this.env.getMessager().printMessage(Diagnostic.Kind.NOTE, "Serializing Entity types");
            this.serialize(this.configuration.getEntitySerializer(), this.entityTypes.values());
        }
        if (!this.extensionTypes.isEmpty()) {
            this.env.getMessager().printMessage(Diagnostic.Kind.NOTE, "Serializing Extension types");
            this.serialize(this.configuration.getEmbeddableSerializer(), this.extensionTypes.values());
        }
        if (!this.embeddables.isEmpty()) {
            this.env.getMessager().printMessage(Diagnostic.Kind.NOTE, "Serializing Embeddable types");
            this.serialize(this.configuration.getEmbeddableSerializer(), this.embeddables.values());
        }
        if (!this.projectionTypes.isEmpty()) {
            this.env.getMessager().printMessage(Diagnostic.Kind.NOTE, "Serializing Projection types");
            this.serialize(this.configuration.getDTOSerializer(), this.projectionTypes.values());
        }
    }

    private void serializeVariableClasses() {
        for (Element element : this.getElements(Variables.class)) {
            if (!(element instanceof PackageElement)) continue;
            Variables vars = element.getAnnotation(Variables.class);
            PackageElement packageElement = (PackageElement)element;
            ArrayList<EntityType> models = new ArrayList<EntityType>();
            for (EntityType model : this.entityTypes.values()) {
                if (!model.getPackageName().equals(packageElement.getQualifiedName().toString())) continue;
                models.add(model);
            }
            this.serializeVariableList(packageElement.getQualifiedName().toString(), vars, models);
        }
    }

    @Nullable
    private FileObject getSourceFile(String fullName) throws IOException {
        Elements elementUtils = this.env.getElementUtils();
        TypeElement sourceElement = elementUtils.getTypeElement(fullName);
        if (sourceElement == null) {
            return null;
        }
        if (sourceElement.getNestingKind().isNested()) {
            sourceElement = (TypeElement)sourceElement.getEnclosingElement();
        }
        PackageElement packageElement = elementUtils.getPackageOf(sourceElement);
        try {
            return this.env.getFiler().getResource(StandardLocation.SOURCE_PATH, packageElement.getQualifiedName(), sourceElement.getSimpleName() + ".java");
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serialize(Serializer serializer, Collection<EntityType> models) {
        Messager msg = this.env.getMessager();
        for (EntityType model : models) {
            try {
                String className;
                Type type = this.configuration.getTypeMappings().getPathType((Type)model, model, true);
                String packageName = type.getPackageName();
                String string = className = !packageName.isEmpty() ? packageName + "." + type.getSimpleName() : type.getSimpleName();
                if (this.configuration.isExcludedPackage(model.getPackageName()) || this.configuration.isExcludedClass(model.getFullName())) continue;
                Filer filer = this.env.getFiler();
                Set<TypeElement> elements = this.typeElements.get(model.getFullName());
                boolean generate = false;
                try {
                    FileObject generatedFile = filer.getResource(StandardLocation.SOURCE_OUTPUT, packageName, type.getSimpleName() + ".java");
                    if (elements != null) {
                        boolean foundSources = false;
                        for (TypeElement element : elements) {
                            FileObject sourceFile = this.getSourceFile(element.getQualifiedName().toString());
                            if (sourceFile == null || sourceFile.getLastModified() <= 0L) continue;
                            foundSources = true;
                            generate |= generatedFile.getLastModified() <= sourceFile.getLastModified();
                        }
                        if (!foundSources) {
                            generate = this.configuration.isDefaultOverwrite() ? true : generatedFile.getLastModified() <= 0L;
                        }
                    } else {
                        generate = this.configuration.isDefaultOverwrite() ? true : generatedFile.getLastModified() <= 0L;
                    }
                }
                catch (FileNotFoundException e) {
                    generate = true;
                }
                if (generate) {
                    if (elements == null) {
                        elements = new HashSet<TypeElement>();
                    }
                    for (Property property : model.getProperties()) {
                        Set<TypeElement> customElements;
                        if (property.getType().getCategory() != TypeCategory.CUSTOM || (customElements = this.typeElements.get(property.getType().getFullName())) == null) continue;
                        elements.addAll(customElements);
                    }
                    msg.printMessage(Diagnostic.Kind.NOTE, "Generating " + className + " for " + elements);
                    JavaFileObject fileObject = this.env.getFiler().createSourceFile(className, elements.toArray(new Element[elements.size()]));
                    Writer writer = fileObject.openWriter();
                    try {
                        SerializerConfig serializerConfig = this.configuration.getSerializerConfig(model);
                        serializer.serialize(model, serializerConfig, (CodeWriter)new JavaWriter((Appendable)writer));
                        continue;
                    }
                    finally {
                        if (writer != null) {
                            writer.close();
                        }
                        continue;
                    }
                }
                msg.printMessage(Diagnostic.Kind.NOTE, className + " is up-to-date ");
            }
            catch (IOException e) {
                e.printStackTrace();
                msg.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeVariableList(String packageName, Variables vars, List<EntityType> models) {
        String className = packageName + "." + vars.value();
        TypeMappings typeMappings = this.configuration.getTypeMappings();
        try {
            JavaFileObject fileObject = this.env.getFiler().createSourceFile(className, new Element[0]);
            Writer w = fileObject.openWriter();
            try {
                JavaWriter writer = new JavaWriter((Appendable)w);
                writer.packageDecl(packageName);
                SimpleType simpleType = new SimpleType(packageName + "." + vars.value(), packageName, vars.value(), new Type[0]);
                if (vars.asInterface()) {
                    writer.beginInterface((Type)simpleType, new Type[0]);
                } else {
                    writer.beginClass((Type)simpleType, null, new Type[0]);
                }
                for (EntityType model : models) {
                    String simpleName;
                    Type queryType = typeMappings.getPathType((Type)model, model, true);
                    String alias = simpleName = model.getUncapSimpleName();
                    if (this.configuration.getKeywords().contains(simpleName.toUpperCase())) {
                        alias = alias + "1";
                    }
                    writer.publicStaticFinal(queryType, simpleName, "new " + queryType.getSimpleName() + "(\"" + alias + "\")");
                }
                writer.end();
            }
            finally {
                w.close();
            }
        }
        catch (IOException e) {
            this.env.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        }
    }
}

