/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt.jpa;

import com.mysema.query.annotations.QueryType;
import com.mysema.query.apt.DefaultConfiguration;
import com.mysema.query.apt.VisitorConfig;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

public class JPAConfiguration
extends DefaultConfiguration {
    private static final Collection<String> KEYWORDS = new HashSet<String>(Arrays.asList("ABS", "ALL", "AND", "ANY", "AS", "ASC", "AVG", "BETWEEN", "BIT_LENGTH[51]", "BOTH", "BY", "CASE", "CHAR_LENGTH", "CHARACTER_LENGTH", "CLASS", "COALESCE", "CONCAT", "COUNT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "DELETE", "DESC", "DISTINCT", "ELSE", "EMPTY", "END", "ENTRY", "ESCAPE", "EXISTS", "FALSE", "FETCH", "FROM", "GROUP", "HAVING", "IN", "INDEX", "INNER", "IS", "JOIN", "KEY", "LEADING", "LEFT", "LENGTH", "LIKE", "LOCATE", "LOWER", "MAX", "MEMBER", "MIN", "MOD", "NEW", "NOT", "NULL", "NULLIF", "OBJECT", "OF", "OR", "ORDER", "OUTER", "POSITION", "SELECT", "SET", "SIZE", "SOME", "SQRT", "SUBSTRING", "SUM", "THEN", "TRAILING", "TRIM", "TRUE", "TYPE", "UNKNOWN", "UPDATE", "UPPER", "VALUE", "WHEN", "WHERE"));
    private final List<Class<? extends Annotation>> annotations = this.getAnnotations();

    public JPAConfiguration(RoundEnvironment roundEnv, Map<String, String> options, Class<? extends Annotation> entityAnn, Class<? extends Annotation> superTypeAnn, Class<? extends Annotation> embeddableAnn, Class<? extends Annotation> embeddedAnn, Class<? extends Annotation> skipAnn) throws ClassNotFoundException {
        super(roundEnv, options, KEYWORDS, null, entityAnn, superTypeAnn, embeddableAnn, embeddedAnn, skipAnn);
    }

    protected List<Class<? extends Annotation>> getAnnotations() throws ClassNotFoundException {
        ArrayList<Class<? extends Annotation>> rv = new ArrayList<Class<? extends Annotation>>();
        rv.add(QueryType.class);
        for (String fullName : Arrays.asList("javax.persistence.Column", "javax.persistence.Embedded", "javax.persistence.EmbeddedId", "javax.persistence.GeneratedValue", "javax.persistence.Id", "javax.persistence.Version", "javax.persistence.JoinColumn", "javax.persistence.ManyToOne", "javax.persistence.OneToMany", "javax.persistence.PrimaryKeyJoinColumn", "com.mysema.query.annotations.QueryType", "com.mysema.query.annotations.QueryTransient")) {
            rv.add(Class.forName(fullName));
        }
        return rv;
    }

    @Override
    public VisitorConfig getConfig(TypeElement e, List<? extends Element> elements) {
        boolean fields = false;
        boolean methods = false;
        for (Element element : elements) {
            if (!this.hasRelevantAnnotation(element)) continue;
            if (element.getKind().equals((Object)ElementKind.FIELD)) {
                fields = true;
                continue;
            }
            if (!element.getKind().equals((Object)ElementKind.METHOD)) continue;
            methods = true;
        }
        if (fields && !methods) {
            return VisitorConfig.FIELDS_ONLY;
        }
        if (methods && !fields) {
            return VisitorConfig.METHODS_ONLY;
        }
        return VisitorConfig.ALL;
    }

    private boolean hasRelevantAnnotation(Element element) {
        for (Class<? extends Annotation> annotation : this.annotations) {
            if (element.getAnnotation(annotation) == null) continue;
            return true;
        }
        return false;
    }
}

