/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt;

import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.codegen.model.TypeExtends;
import com.mysema.codegen.model.TypeSuper;
import com.mysema.codegen.model.Types;
import com.mysema.query.apt.Configuration;
import com.mysema.query.apt.TypeArgumentsException;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.QueryTypeFactory;
import com.mysema.query.codegen.Supertype;
import com.mysema.query.codegen.TypeMappings;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;

public final class ExtendedTypeFactory {
    private final Map<List<String>, Type> typeCache = new HashMap<List<String>, Type>();
    private final Type defaultType;
    private final Set<Class<? extends Annotation>> entityAnnotations;
    private final Map<List<String>, EntityType> entityTypeCache = new HashMap<List<String>, EntityType>();
    private final ProcessingEnvironment env;
    private final TypeElement numberType;
    private final TypeElement comparableType;
    private boolean doubleIndexEntities = true;
    private final TypeMappings typeMappings;
    private final QueryTypeFactory queryTypeFactory;

    @Nullable
    private static Class<?> safeClassForName(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public ExtendedTypeFactory(ProcessingEnvironment env, Configuration configuration, Set<Class<? extends Annotation>> annotations, TypeMappings typeMappings, QueryTypeFactory queryTypeFactory) {
        this.env = env;
        this.defaultType = Types.OBJECT;
        this.entityAnnotations = annotations;
        this.numberType = env.getElementUtils().getTypeElement(Number.class.getName());
        this.comparableType = env.getElementUtils().getTypeElement(Comparable.class.getName());
        this.typeMappings = typeMappings;
        this.queryTypeFactory = queryTypeFactory;
    }

    private void appendToKey(List<String> key, DeclaredType t, boolean deep) {
        for (TypeMirror typeMirror : t.getTypeArguments()) {
            if (deep) {
                key.addAll(this.createKey(typeMirror, false));
                continue;
            }
            key.add(((Object)typeMirror).toString());
        }
    }

    private void appendToKey(List<String> key, TypeVariable t) {
        if (t.getUpperBound() != null) {
            key.addAll(this.createKey(t.getUpperBound(), false));
        }
        if (t.getLowerBound() != null) {
            key.addAll(this.createKey(t.getLowerBound(), false));
        }
    }

    private void appendToKey(List<String> key, WildcardType t) {
        if (t.getExtendsBound() != null) {
            key.addAll(this.createKey(t.getExtendsBound(), false));
        }
        if (t.getSuperBound() != null) {
            key.addAll(this.createKey(t.getSuperBound(), false));
        }
    }

    private Type createType(TypeElement typeElement, TypeCategory category, List<? extends TypeMirror> typeArgs, boolean deep) {
        String name = typeElement.getQualifiedName().toString();
        String simpleName = typeElement.getSimpleName().toString();
        String packageName = this.env.getElementUtils().getPackageOf(typeElement).getQualifiedName().toString();
        Type[] params = new Type[typeArgs.size()];
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.getType(typeArgs.get(i), deep);
        }
        return new SimpleType(category, name, packageName, simpleName, false, typeElement.getModifiers().contains((Object)Modifier.FINAL), params);
    }

    @Nullable
    public Type getType(TypeMirror typeMirror, boolean deep) {
        List<String> key;
        if (typeMirror.getKind().isPrimitive()) {
            typeMirror = this.normalizePrimitiveType(typeMirror);
        }
        if (this.entityTypeCache.containsKey(key = this.createKey(typeMirror, true))) {
            return (Type)this.entityTypeCache.get(key);
        }
        if (this.typeCache.containsKey(key)) {
            return this.typeCache.get(key);
        }
        return this.createType(typeMirror, key, deep);
    }

    @Nullable
    private Type createType(TypeMirror typeMirror, List<String> key, boolean deep) {
        this.typeCache.put(key, null);
        Type type = this.handle(typeMirror, deep);
        if (type != null && (type.getCategory() == TypeCategory.ENTITY || type.getCategory() == TypeCategory.CUSTOM)) {
            EntityType entityType = this.getEntityType(typeMirror, deep);
            this.typeCache.put(key, (Type)entityType);
            return entityType;
        }
        this.typeCache.put(key, type);
        return type;
    }

    private Type createClassType(DeclaredType declaredType, TypeElement typeElement, boolean deep) {
        TypeMirror type;
        String name = typeElement.getQualifiedName().toString();
        TypeCategory typeCategory = TypeCategory.get((String)name);
        if (typeCategory != TypeCategory.NUMERIC && this.isImplemented(typeElement, this.comparableType) && this.isSubType(typeElement, this.numberType)) {
            typeCategory = TypeCategory.NUMERIC;
        } else if (!typeCategory.isSubCategoryOf(TypeCategory.COMPARABLE) && this.isImplemented(typeElement, this.comparableType)) {
            typeCategory = TypeCategory.COMPARABLE;
        }
        if (typeCategory == TypeCategory.SIMPLE) {
            for (Class<? extends Annotation> entityAnn : this.entityAnnotations) {
                if (typeElement.getAnnotation(entityAnn) == null) continue;
                typeCategory = TypeCategory.ENTITY;
            }
        }
        if (name.equals("")) {
            type = this.env.getElementUtils().getTypeElement(Object.class.getName()).asType();
            if (typeCategory == TypeCategory.COMPARABLE) {
                type = this.env.getElementUtils().getTypeElement(Comparable.class.getName()).asType();
            }
            List<? extends TypeMirror> superTypes = this.env.getTypeUtils().directSupertypes(declaredType);
            for (TypeMirror typeMirror : superTypes) {
                if (!this.env.getTypeUtils().isSubtype(typeMirror, type)) continue;
                type = typeMirror;
            }
            typeElement = (TypeElement)this.env.getTypeUtils().asElement(type);
        }
        type = typeElement.asType() instanceof DeclaredType && declaredType.getTypeArguments().isEmpty() ? this.createType(typeElement, typeCategory, ((DeclaredType)typeElement.asType()).getTypeArguments(), deep) : this.createType(typeElement, typeCategory, declaredType.getTypeArguments(), deep);
        for (Class<? extends Annotation> entityAnn : this.entityAnnotations) {
            if (typeElement.getAnnotation(entityAnn) == null) continue;
            EntityType entityType = new EntityType((Type)type);
            this.typeMappings.register((Type)entityType, this.queryTypeFactory.create((Type)entityType));
            return entityType;
        }
        return type;
    }

    private Type createMapType(String simpleName, Iterator<? extends TypeMirror> typeMirrors, boolean deep) {
        Type type;
        TypeElement element;
        Type valueType;
        if (!typeMirrors.hasNext()) {
            throw new TypeArgumentsException(simpleName);
        }
        Type keyType = this.getType(typeMirrors.next(), deep);
        if (keyType == null) {
            keyType = this.defaultType;
        }
        if ((valueType = this.getType(typeMirrors.next(), deep)).getParameters().isEmpty() && (element = this.env.getElementUtils().getTypeElement(valueType.getFullName())) != null && !(type = this.getType(element.asType(), deep)).getParameters().isEmpty()) {
            valueType = new SimpleType(valueType, new Type[type.getParameters().size()]);
        }
        return new SimpleType((Type)Types.MAP, new Type[]{keyType, valueType});
    }

    private Type createCollectionType(String simpleName, Iterator<? extends TypeMirror> typeMirrors, boolean deep) {
        return this.createCollectionType((Type)Types.COLLECTION, simpleName, typeMirrors, deep);
    }

    private Type createListType(String simpleName, Iterator<? extends TypeMirror> typeMirrors, boolean deep) {
        return this.createCollectionType((Type)Types.LIST, simpleName, typeMirrors, deep);
    }

    private Type createSetType(String simpleName, Iterator<? extends TypeMirror> typeMirrors, boolean deep) {
        return this.createCollectionType((Type)Types.SET, simpleName, typeMirrors, deep);
    }

    private Type createCollectionType(Type baseType, String simpleName, Iterator<? extends TypeMirror> typeMirrors, boolean deep) {
        Type type;
        TypeElement element;
        if (!typeMirrors.hasNext()) {
            throw new TypeArgumentsException(simpleName);
        }
        Type componentType = this.getType(typeMirrors.next(), deep);
        if (componentType.getParameters().isEmpty() && (element = this.env.getElementUtils().getTypeElement(componentType.getFullName())) != null && !(type = this.getType(element.asType(), deep)).getParameters().isEmpty()) {
            componentType = new SimpleType(componentType, new Type[type.getParameters().size()]);
        }
        return new SimpleType(baseType, new Type[]{componentType});
    }

    @Nullable
    public EntityType getEntityType(TypeMirror typeMirrors, boolean deep) {
        List<String> key;
        if (typeMirrors.getKind().isPrimitive()) {
            typeMirrors = this.normalizePrimitiveType(typeMirrors);
        }
        if (this.entityTypeCache.containsKey(key = this.createKey(typeMirrors, true))) {
            EntityType entityType = this.entityTypeCache.get(key);
            if (deep && entityType.getSuperTypes().isEmpty()) {
                for (Type superType : this.getSupertypes(typeMirrors, (Type)entityType, deep)) {
                    entityType.addSupertype(new Supertype(superType));
                }
            }
            return entityType;
        }
        return this.createEntityType(typeMirrors, key, deep);
    }

    @Nullable
    private EntityType createEntityType(TypeMirror typeMirror, List<String> key, boolean deep) {
        this.entityTypeCache.put(key, null);
        Type value = this.handle(typeMirror, deep);
        if (value != null) {
            EntityType entityType = null;
            if (value instanceof EntityType) {
                entityType = (EntityType)value;
            } else {
                entityType = new EntityType(value);
                this.typeMappings.register((Type)entityType, this.queryTypeFactory.create((Type)entityType));
            }
            this.entityTypeCache.put(key, entityType);
            if (key.size() > 1 && key.get(0).equals(entityType.getFullName()) && this.doubleIndexEntities) {
                ArrayList<String> newKey = new ArrayList<String>();
                newKey.add(entityType.getFullName());
                for (int i = 0; i < entityType.getParameters().size(); ++i) {
                    newKey.add("?");
                }
                if (!this.entityTypeCache.containsKey(newKey)) {
                    this.entityTypeCache.put(newKey, entityType);
                }
            }
            if (deep) {
                for (Type superType : this.getSupertypes(typeMirror, value, deep)) {
                    entityType.addSupertype(new Supertype(superType));
                }
            }
            return entityType;
        }
        return null;
    }

    private Type createEnumType(DeclaredType declaredType, TypeElement typeElement, boolean deep) {
        Type enumType = this.createType(typeElement, TypeCategory.ENUM, declaredType.getTypeArguments(), deep);
        for (Class<? extends Annotation> entityAnn : this.entityAnnotations) {
            if (typeElement.getAnnotation(entityAnn) == null) continue;
            EntityType entityType = new EntityType(enumType);
            this.typeMappings.register((Type)entityType, this.queryTypeFactory.create((Type)entityType));
            return entityType;
        }
        return enumType;
    }

    private Type createInterfaceType(DeclaredType declaredType, TypeElement typeElement, boolean deep) {
        for (Class<? extends Annotation> entityAnn : this.entityAnnotations) {
            if (typeElement.getAnnotation(entityAnn) == null) continue;
            return this.createType(typeElement, TypeCategory.ENTITY, declaredType.getTypeArguments(), deep);
        }
        String name = typeElement.getQualifiedName().toString();
        String simpleName = typeElement.getSimpleName().toString();
        Iterator<? extends TypeMirror> i = declaredType.getTypeArguments().iterator();
        Class<?> cl = ExtendedTypeFactory.safeClassForName(name);
        if (cl == null) {
            return this.createType(typeElement, TypeCategory.get((String)name), declaredType.getTypeArguments(), deep);
        }
        if (Map.class.isAssignableFrom(cl)) {
            return this.createMapType(simpleName, i, deep);
        }
        if (List.class.isAssignableFrom(cl)) {
            return this.createListType(simpleName, i, deep);
        }
        if (Set.class.isAssignableFrom(cl)) {
            return this.createSetType(simpleName, i, deep);
        }
        if (Collection.class.isAssignableFrom(cl)) {
            return this.createCollectionType(simpleName, i, deep);
        }
        return this.createType(typeElement, TypeCategory.get((String)name), declaredType.getTypeArguments(), deep);
    }

    private List<String> createKey(TypeMirror typeMirror, boolean deep) {
        ArrayList<String> key = new ArrayList<String>();
        String name = ((Object)typeMirror).toString();
        if (name.contains("<")) {
            name = name.substring(0, name.indexOf(60));
        }
        key.add(name);
        if (typeMirror.getKind() == TypeKind.TYPEVAR) {
            this.appendToKey(key, (TypeVariable)typeMirror);
        } else if (typeMirror.getKind() == TypeKind.WILDCARD) {
            this.appendToKey(key, (WildcardType)typeMirror);
        } else if (typeMirror.getKind() == TypeKind.DECLARED) {
            this.appendToKey(key, (DeclaredType)typeMirror, deep);
        }
        return key;
    }

    private Set<Type> getSupertypes(TypeMirror typeMirror, Type type, boolean deep) {
        boolean doubleIndex = this.doubleIndexEntities;
        this.doubleIndexEntities = false;
        Set<Type> superTypes = Collections.emptySet();
        if ((typeMirror = this.normalize(typeMirror)).getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            TypeElement e = (TypeElement)declaredType.asElement();
            if (e.getKind() == ElementKind.CLASS) {
                if (e.getSuperclass().getKind() != TypeKind.NONE) {
                    TypeMirror supertype = this.normalize(e.getSuperclass());
                    Type type2 = this.getType(supertype, deep);
                    if (type2 == null) {
                        System.err.println("Got no type for " + supertype);
                    } else if (!type2.getFullName().startsWith("java")) {
                        superTypes = Collections.singleton(this.getType(supertype, deep));
                    }
                }
            } else {
                superTypes = new HashSet(e.getInterfaces().size());
                for (TypeMirror typeMirror2 : e.getInterfaces()) {
                    Type iface = this.getType(typeMirror2, deep);
                    if (iface.getFullName().startsWith("java")) continue;
                    superTypes.add(iface);
                }
            }
        } else {
            return Collections.emptySet();
        }
        this.doubleIndexEntities = doubleIndex;
        return superTypes;
    }

    @Nullable
    private Type handle(TypeMirror typeMirror, boolean deep) {
        if (typeMirror instanceof DeclaredType) {
            return this.handleDeclaredType((DeclaredType)typeMirror, deep);
        }
        if (typeMirror instanceof TypeVariable) {
            return this.handleTypeVariable((TypeVariable)typeMirror, deep);
        }
        if (typeMirror instanceof WildcardType) {
            return this.handleWildcard((WildcardType)typeMirror, deep);
        }
        if (typeMirror instanceof ArrayType) {
            ArrayType t = (ArrayType)typeMirror;
            return this.getType(t.getComponentType(), deep).asArrayType();
        }
        if (typeMirror instanceof NoType) {
            return this.defaultType;
        }
        return null;
    }

    private Type handleDeclaredType(DeclaredType declaredType, boolean deep) {
        if (declaredType.asElement() instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            switch (typeElement.getKind()) {
                case ENUM: {
                    return this.createEnumType(declaredType, typeElement, deep);
                }
                case CLASS: {
                    return this.createClassType(declaredType, typeElement, deep);
                }
                case INTERFACE: {
                    return this.createInterfaceType(declaredType, typeElement, deep);
                }
            }
            throw new IllegalArgumentException("Illegal type " + typeElement);
        }
        throw new IllegalArgumentException("Unsupported element type " + declaredType.asElement());
    }

    private TypeMirror normalizePrimitiveType(TypeMirror typeMirror) {
        switch (typeMirror.getKind()) {
            case BOOLEAN: {
                return this.env.getElementUtils().getTypeElement(Boolean.class.getName()).asType();
            }
            case BYTE: {
                return this.env.getElementUtils().getTypeElement(Byte.class.getName()).asType();
            }
            case CHAR: {
                return this.env.getElementUtils().getTypeElement(Character.class.getName()).asType();
            }
            case DOUBLE: {
                return this.env.getElementUtils().getTypeElement(Double.class.getName()).asType();
            }
            case FLOAT: {
                return this.env.getElementUtils().getTypeElement(Float.class.getName()).asType();
            }
            case INT: {
                return this.env.getElementUtils().getTypeElement(Integer.class.getName()).asType();
            }
            case LONG: {
                return this.env.getElementUtils().getTypeElement(Long.class.getName()).asType();
            }
            case SHORT: {
                return this.env.getElementUtils().getTypeElement(Short.class.getName()).asType();
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)typeMirror.getKind()) + " for " + typeMirror);
    }

    @Nullable
    private Type handleTypeVariable(TypeVariable typeVariable, boolean deep) {
        String varName = typeVariable.toString();
        if (typeVariable.getUpperBound() != null) {
            Type type = this.handle(typeVariable.getUpperBound(), deep);
            return new TypeExtends(varName, type);
        }
        if (typeVariable.getLowerBound() != null && !(typeVariable.getLowerBound() instanceof NullType)) {
            return new TypeSuper(varName, this.handle(typeVariable.getLowerBound(), deep));
        }
        return null;
    }

    @Nullable
    private Type handleWildcard(WildcardType wildardType, boolean deep) {
        if (wildardType.getExtendsBound() != null) {
            Type type = this.handle(wildardType.getExtendsBound(), deep);
            return new TypeExtends(type);
        }
        if (wildardType.getSuperBound() != null) {
            return new TypeSuper(this.handle(wildardType.getSuperBound(), deep));
        }
        return null;
    }

    private boolean isImplemented(TypeElement type, TypeElement iface) {
        for (TypeMirror typeMirror : type.getInterfaces()) {
            String name = ((Object)typeMirror).toString();
            if (name.contains("<")) {
                name = name.substring(0, name.indexOf(60));
            }
            if (!name.equals(iface.getQualifiedName().toString())) continue;
            return true;
        }
        if (type.getSuperclass() != null) {
            TypeElement superType = (TypeElement)this.env.getTypeUtils().asElement(type.getSuperclass());
            if (superType != null) {
                return this.isImplemented(superType, iface);
            }
            superType = this.env.getElementUtils().getTypeElement(((Object)type.getSuperclass()).toString());
            if (superType != null) {
                return this.isImplemented(superType, iface);
            }
            return false;
        }
        return false;
    }

    private boolean isSubType(TypeElement type1, TypeElement type2) {
        return this.env.getTypeUtils().isSubtype(type1.asType(), type2.asType());
    }

    private TypeMirror normalize(TypeMirror type) {
        WildcardType wildcard;
        if (type.getKind() == TypeKind.TYPEVAR) {
            TypeVariable typeVar = (TypeVariable)type;
            if (typeVar.getUpperBound() != null) {
                return typeVar.getUpperBound();
            }
        } else if (type.getKind() == TypeKind.WILDCARD && (wildcard = (WildcardType)type).getExtendsBound() != null) {
            return wildcard.getExtendsBound();
        }
        return type;
    }
}

