/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.testing.plugins.jetty.locator;

import com.mycila.testing.plugins.jetty.locator.AntFileLocator;
import com.mycila.testing.plugins.jetty.locator.FileLocator;
import com.mycila.testing.plugins.jetty.locator.PathFileLocator;
import com.mycila.testing.plugins.jetty.locator.RegFileLocator;
import com.mycila.testing.plugins.jetty.locator.SysFileLocator;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.EnumSet;

public class StrategyFileLocator
implements FileLocator {
    public File locate(String path) throws FileNotFoundException {
        Strategy strategy = Strategy.findStrategy(path);
        File file = strategy.getLocator().locate(strategy.cleanPath(path));
        return file;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Strategy {
        DEFAULT("", new PathFileLocator()),
        REG("reg:", new RegFileLocator()),
        ANT("ant:", new AntFileLocator()),
        SYS("sys:", new SysFileLocator());

        private final String code;
        private final FileLocator fileLocator;

        private Strategy(String code, FileLocator fileLocator) {
            this.code = code;
            this.fileLocator = fileLocator;
        }

        boolean matches(String path) {
            boolean matches = path != null && (!DEFAULT.equals((Object)this) && path.startsWith(this.code) || DEFAULT.equals((Object)this));
            return matches;
        }

        String cleanPath(String path) {
            if (path == null) {
                throw new NullPointerException("path should not be null");
            }
            if (!this.matches(path)) {
                throw new IllegalArgumentException("path should starts with " + this.code);
            }
            int from = this.code.length();
            int to = path.length();
            String clean = path.substring(from, to);
            return clean;
        }

        FileLocator getLocator() {
            return this.fileLocator;
        }

        static Strategy findStrategy(String path) {
            for (Strategy strategy : EnumSet.complementOf(EnumSet.of(DEFAULT))) {
                boolean matches = strategy.matches(path);
                if (!matches) continue;
                return strategy;
            }
            return DEFAULT;
        }
    }
}

