/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.testing.plugins.jetty.locator;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mycila.testing.plugins.jetty.locator.BooleanSwitchFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AntPath {
    private final String antPath;

    public AntPath(String antPath) {
        this.antPath = antPath;
    }

    public boolean matches(String path) {
        boolean matches = path.matches(this.toRegex());
        return matches;
    }

    String toRegex() {
        Iterable<String> splits = this.split();
        String joined = Joiner.on((String)"").skipNulls().join(Iterables.transform(splits, (Function)new Function<String, String>(){

            public String apply(String input) {
                String regex = input.length() == 0 ? null : ("?".equals(input) ? "[^/]" : ("*".equals(input) ? "[^/]*" : ("**".equals(input) ? ".*?" : ("**/".equals(input) ? "([^/]+?/)*?" : "\\Q" + input + "\\E"))));
                return regex;
            }
        }));
        return joined;
    }

    private Iterable<String> split() {
        Iterable splits = Lists.newArrayList((Object[])new String[]{this.antPath});
        splits = Iterables.concat((Iterable)Iterables.transform((Iterable)splits, (Function)new MultiSplitFunction("?", "**/", "**", "*")));
        return splits;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class InputAsIterableFunction
    implements Function<String, Iterable<String>> {
        InputAsIterableFunction() {
        }

        public Iterable<String> apply(String input) {
            return Lists.newArrayList((Object[])new String[]{input});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SplitFunction
    implements Function<String, Iterable<String>> {
        private final String separator;

        public SplitFunction(String separator) {
            this.separator = separator;
        }

        public Iterable<String> apply(String input) {
            Iterable parts = Splitter.on((String)this.separator).split((CharSequence)input);
            Iterable<String> splits = SplitFunction.insertBetweenEach(parts, this.separator);
            return splits;
        }

        private static Iterable<String> insertBetweenEach(Iterable<String> elements, String separator) {
            ArrayList list = Lists.newArrayList(elements);
            ListIterator<String> iter = list.listIterator();
            while (iter.hasNext()) {
                if (iter.nextIndex() > 0 && iter.hasNext()) {
                    iter.add(separator);
                }
                iter.next();
            }
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MultiSplitFunction
    implements Function<String, Iterable<String>> {
        private final Iterable<String> separators;

        public MultiSplitFunction(Iterable<String> separators) {
            this.separators = separators;
        }

        public MultiSplitFunction(String ... separators) {
            this(Lists.newArrayList((Object[])separators));
        }

        public Iterable<String> apply(String input) {
            ArrayList toIgnores = Lists.newArrayList();
            Iterable<Object> splits = Lists.newArrayList((Object[])new String[]{input});
            for (String separator : this.separators) {
                splits = this.split(splits, separator, toIgnores);
                toIgnores.add(separator);
            }
            return splits;
        }

        private Iterable<String> split(Iterable<String> inputs, String separator, Iterable<String> toIgnore) {
            BooleanSwitchFunction<String, Iterable<String>> splitter = new BooleanSwitchFunction<String, Iterable<String>>(Predicates.not((Predicate)Predicates.in((Collection)Lists.newArrayList(toIgnore))), new SplitFunction(separator), new InputAsIterableFunction());
            Iterable splits = Iterables.concat((Iterable)Iterables.transform(inputs, splitter));
            return splits;
        }
    }
}

