/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.testing.plugins.jetty;

import com.google.common.base.Throwables;
import com.mycila.testing.plugins.jetty.config.Config;
import com.mycila.testing.plugins.jetty.config.DefaultConfig;
import java.lang.reflect.Method;

public class WebappHelper {
    public static String getWebappUrl(Object instance) {
        return WebappHelper.getWebappUrl(DefaultConfig.configFrom(instance.getClass()));
    }

    public static String getWebappUrl(Object instance, String methodName) {
        try {
            return WebappHelper.getWebappUrl(instance.getClass().getMethod(methodName, new Class[0]));
        }
        catch (SecurityException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static String getWebappUrl(Method method) {
        return WebappHelper.getWebappUrl(DefaultConfig.configFrom(method));
    }

    private static String getWebappUrl(Config config) {
        String path = config.getContextPath();
        String contextPath = "/".equals(path) ? "" : path;
        String url = "http://localhost:" + config.getServerPort() + contextPath;
        return url;
    }
}

