/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.testing.core;

import com.mycila.log.Logger;
import com.mycila.log.Loggers;
import com.mycila.testing.MycilaTestingException;
import com.mycila.testing.core.api.Ensure;
import com.mycila.testing.core.api.Execution;
import com.mycila.testing.core.api.TestContext;
import java.util.IdentityHashMap;
import java.util.Map;

public final class Mycila {
    private static final Logger LOGGER = Loggers.get(Mycila.class);
    private static final ThreadLocal<Execution> CURRENT_EXECUTION = new InheritableThreadLocal<Execution>();
    private static final Map<Object, TestContext> CONTEXTS = new IdentityHashMap<Object, TestContext>(10000);

    private Mycila() {
    }

    static void registerCurrentExecution(Execution execution) {
        Ensure.notNull("Execution context", execution);
        LOGGER.debug((Object)"Registering Execution Context %s#%s for test %s#%s", new Object[]{execution.step(), execution.method().getName(), execution.context().introspector().testClass().getName(), execution.context().introspector().instance().hashCode()});
        CURRENT_EXECUTION.set(execution);
    }

    static void registerContext(TestContext context) {
        Ensure.notNull("Test context", context);
        LOGGER.debug((Object)"Registering Global Test Context for test %s#%s", new Object[]{context.introspector().testClass().getName(), context.introspector().instance().hashCode()});
        CONTEXTS.put(context.introspector().instance(), context);
    }

    static void unsetCurrentExecution() {
        Execution execution;
        if (LOGGER.canDebug() && (execution = CURRENT_EXECUTION.get()) != null) {
            LOGGER.debug((Object)"Removing Execution Context %s#%s for test %s#%s", new Object[]{execution.step(), execution.method().getName(), execution.context().introspector().testClass().getName(), execution.context().introspector().instance().hashCode()});
        }
        CURRENT_EXECUTION.remove();
    }

    static void unsetContext(TestContext context) {
        Ensure.notNull("Test context", context);
        if (CONTEXTS.remove(context.introspector().instance()) != null) {
            LOGGER.debug((Object)"Removing Global Test Context for test %s#%s", new Object[]{context.introspector().testClass().getName(), context.introspector().instance().hashCode()});
        }
    }

    public static TestContext context(Object testInstance) {
        Ensure.notNull("Test instance", testInstance);
        TestContext context = CONTEXTS.get(testInstance);
        if (context == null) {
            throw new MycilaTestingException("No Global Test Context available for test %s#%s", testInstance.getClass().getName(), testInstance.hashCode());
        }
        return context;
    }

    public static Execution currentExecution() {
        Execution c = CURRENT_EXECUTION.get();
        if (c == null) {
            throw new IllegalStateException("No Execution context bound to local thread !");
        }
        return c;
    }
}

