/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.testing.core;

import com.mycila.testing.core.api.Attributes;
import com.mycila.testing.core.api.Ensure;
import com.mycila.testing.core.api.TestPluginException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AttributesImpl
implements Attributes {
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    AttributesImpl() {
    }

    @Override
    public <T> T get(String name) {
        Ensure.notNull("Attribute name", name);
        Object att = this.attributes.get(name);
        if (att == null) {
            throw new TestPluginException("Inexisting attribute: '%s'", name);
        }
        return (T)att;
    }

    @Override
    public boolean has(String name) {
        Ensure.notNull("Attribute name", name);
        return this.attributes.containsKey(name);
    }

    @Override
    public void set(String name, Object value) {
        Ensure.notNull("Attribute name", name);
        this.attributes.put(name, value);
    }

    @Override
    public <T> T remove(String name) {
        Ensure.notNull("Attribute name", name);
        return (T)this.attributes.remove(name);
    }

    @Override
    public Map<String, Object> all() {
        return Collections.unmodifiableMap(this.attributes);
    }
}

