/*
 * Decompiled with CFR 0.152.
 */
package org.tbee.javafx.scene.layout;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.collections.ListChangeListener;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.stage.Screen;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.ComponentWrapper;
import net.miginfocom.layout.ConstraintParser;
import net.miginfocom.layout.ContainerWrapper;
import net.miginfocom.layout.Grid;
import net.miginfocom.layout.LC;
import net.miginfocom.layout.LayoutUtil;

public class MigPane
extends Pane {
    private FX2ContainerWrapper fx2ContainerWrapper;
    protected static final Map<Node, CC> cNodeToCC = new WeakHashMap<Node, CC>();
    private volatile LC layoutConstraints = null;
    public static final String LAYOUTCONSTRAINTS_PROPERTY_ID = "layoutConstraints";
    private volatile boolean iDebug = false;
    private volatile AC columnConstraints = null;
    public static final String COLUMNCONSTRAINTS_PROPERTY_ID = "columnConstraints";
    private volatile AC rowConstraints = null;
    public static final String ROWCONSTRAINTS_PROPERTY_ID = "rowConstraints";
    private final List<FX2ComponentWrapper> componentWrapperList = new ArrayList<FX2ComponentWrapper>();
    private final Map<Node, FX2ComponentWrapper> nodeToComponentWrapperMap = new WeakHashMap<Node, FX2ComponentWrapper>();
    private final Map<ComponentWrapper, CC> fx2ComponentWrapperToCCMap = new WeakHashMap<ComponentWrapper, CC>();
    private final Map<Node, Integer> nodeToHashcodeMap = new WeakHashMap<Node, Integer>();
    private volatile Grid grid;
    volatile boolean valid = false;
    private final List<Rectangle> debugRectangles = new ArrayList<Rectangle>();

    public MigPane() {
        this.construct();
    }

    public MigPane(LC lC) {
        this.setLayoutConstraints(lC);
        this.construct();
    }

    public MigPane(LC lC, AC aC) {
        this.setLayoutConstraints(lC);
        this.setColumnConstraints(aC);
        this.construct();
    }

    public MigPane(LC lC, AC aC, AC aC2) {
        this.setLayoutConstraints(lC);
        this.setColumnConstraints(aC);
        this.setRowConstraints(aC2);
        this.construct();
    }

    public MigPane(String string) {
        this.setLayoutConstraints(ConstraintParser.parseLayoutConstraint((String)ConstraintParser.prepare((String)string)));
        this.construct();
    }

    public MigPane(String string, String string2) {
        this.setLayoutConstraints(ConstraintParser.parseLayoutConstraint((String)ConstraintParser.prepare((String)string)));
        this.setColumnConstraints(ConstraintParser.parseColumnConstraints((String)ConstraintParser.prepare((String)string2)));
        this.construct();
    }

    public MigPane(String string, String string2, String string3) {
        this.setLayoutConstraints(ConstraintParser.parseLayoutConstraint((String)ConstraintParser.prepare((String)string)));
        this.setColumnConstraints(ConstraintParser.parseColumnConstraints((String)ConstraintParser.prepare((String)string2)));
        this.setRowConstraints(ConstraintParser.parseRowConstraints((String)ConstraintParser.prepare((String)string3)));
        this.construct();
    }

    private void construct() {
        if (this.getLayoutConstraints() == null) {
            this.setLayoutConstraints(new LC());
        }
        if (this.getRowConstraints() == null) {
            this.setRowConstraints(new AC());
        }
        if (this.getColumnConstraints() == null) {
            this.setColumnConstraints(new AC());
        }
        this.fx2ContainerWrapper = new FX2ContainerWrapper((Node)this);
        this.getChildren().addListener((ListChangeListener)new ListChangeListener<Node>(){

            public void onChanged(ListChangeListener.Change<? extends Node> change) {
                while (change.next()) {
                    FX2ComponentWrapper fX2ComponentWrapper;
                    for (Node node : change.getRemoved()) {
                        if (node instanceof DebugRectangle) continue;
                        fX2ComponentWrapper = (FX2ComponentWrapper)MigPane.this.nodeToComponentWrapperMap.remove(node);
                        MigPane.this.componentWrapperList.remove(fX2ComponentWrapper);
                        MigPane.this.fx2ComponentWrapperToCCMap.remove(fX2ComponentWrapper);
                        MigPane.this.invalidateMigLayoutGrid();
                    }
                    for (Node node : change.getAddedSubList()) {
                        if (node instanceof DebugRectangle) continue;
                        fX2ComponentWrapper = cNodeToCC.remove(node);
                        if (fX2ComponentWrapper == null) {
                            fX2ComponentWrapper = new CC();
                        }
                        FX2ComponentWrapper fX2ComponentWrapper2 = new FX2ComponentWrapper(node);
                        MigPane.this.componentWrapperList.add(fX2ComponentWrapper2);
                        MigPane.this.nodeToComponentWrapperMap.put(node, fX2ComponentWrapper2);
                        MigPane.this.fx2ComponentWrapperToCCMap.put(fX2ComponentWrapper2, fX2ComponentWrapper);
                        MigPane.this.invalidateMigLayoutGrid();
                    }
                }
            }
        });
        this.createMigLayoutGrid();
    }

    public LC getLayoutConstraints() {
        return this.layoutConstraints;
    }

    public void setLayoutConstraints(LC lC) {
        this.layoutConstraints = lC;
        if (lC != null && lC.getDebugMillis() > 0) {
            this.iDebug = true;
        }
    }

    public MigPane withLayoutConstraints(LC lC) {
        this.setLayoutConstraints(lC);
        return this;
    }

    public AC getColumnConstraints() {
        return this.columnConstraints;
    }

    public void setColumnConstraints(AC aC) {
        this.columnConstraints = aC;
    }

    public MigPane withColumnConstraints(AC aC) {
        this.setColumnConstraints(aC);
        return this;
    }

    public AC getRowConstraints() {
        return this.rowConstraints;
    }

    public void setRowConstraints(AC aC) {
        this.rowConstraints = aC;
    }

    public MigPane withRowConstraints(AC aC) {
        this.setRowConstraints(aC);
        return this;
    }

    public void add(Node node, CC cC) {
        cNodeToCC.put(node, cC);
        this.getChildren().add((Object)node);
    }

    public void add(Node node) {
        this.add(node, new CC());
    }

    public void add(Node node, String string) {
        CC cC = ConstraintParser.parseComponentConstraint((String)ConstraintParser.prepare((String)string));
        this.add(node, cC);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.validateMigLayoutGrid();
        int[] nArray = new int[]{0, 0, (int)Math.ceil(this.getWidth()), (int)Math.ceil(this.getHeight())};
        this.grid.layout(nArray, this.getLayoutConstraints().getAlignX(), this.getLayoutConstraints().getAlignY(), this.iDebug, true);
        if (this.iDebug) {
            this.clearDebug();
            this.grid.paintDebug();
        }
    }

    private void createMigLayoutGrid() {
        this.grid = new Grid((ContainerWrapper)this.fx2ContainerWrapper, this.getLayoutConstraints(), this.getRowConstraints(), this.getColumnConstraints(), this.fx2ComponentWrapperToCCMap, null);
        this.valid = true;
        this.setMinWidth(LayoutUtil.getSizeSafe((int[])this.grid.getWidth(), (int)0));
        this.setPrefWidth(LayoutUtil.getSizeSafe((int[])this.grid.getWidth(), (int)1));
        this.setMaxWidth(LayoutUtil.getSizeSafe((int[])this.grid.getWidth(), (int)2));
        this.setMinHeight(LayoutUtil.getSizeSafe((int[])this.grid.getHeight(), (int)0));
        this.setPrefHeight(LayoutUtil.getSizeSafe((int[])this.grid.getHeight(), (int)1));
        this.setMaxHeight(LayoutUtil.getSizeSafe((int[])this.grid.getHeight(), (int)2));
    }

    private void validateMigLayoutGrid() {
        if (this.isMiglayoutGridValid()) {
            for (Node node : this.getChildren()) {
                if (!this.nodeToComponentWrapperMap.containsKey(node)) continue;
                Integer n = this.nodeToHashcodeMap.get(node);
                Integer n2 = this.calculateHashcode(node);
                if (n != null && n.equals(n2)) continue;
                this.invalidateMigLayoutGrid();
                this.nodeToHashcodeMap.put(node, (int)n2);
            }
        }
        if (!this.isMiglayoutGridValid()) {
            this.createMigLayoutGrid();
        }
    }

    private void invalidateMigLayoutGrid() {
        this.valid = false;
    }

    private boolean isMiglayoutGridValid() {
        return this.valid;
    }

    private Integer calculateHashcode(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(node.minWidth(-1.0));
        stringBuffer.append("x");
        stringBuffer.append(node.minHeight(-1.0));
        stringBuffer.append("/");
        stringBuffer.append(node.prefWidth(-1.0));
        stringBuffer.append("x");
        stringBuffer.append(node.prefHeight(-1.0));
        stringBuffer.append("/");
        stringBuffer.append(node.maxWidth(-1.0));
        stringBuffer.append("x");
        stringBuffer.append(node.maxHeight(-1.0));
        stringBuffer.append("/");
        stringBuffer.append(node.getLayoutBounds().getWidth());
        stringBuffer.append("x");
        stringBuffer.append(node.getLayoutBounds().getHeight());
        stringBuffer.append("/");
        stringBuffer.append(node.isVisible());
        return stringBuffer.toString().hashCode();
    }

    public void clearDebug() {
        this.getChildren().removeAll(this.debugRectangles);
        this.debugRectangles.clear();
    }

    private void addDebugRectangle(double d, double d2, double d3, double d4, DebugRectangleType debugRectangleType) {
        DebugRectangle debugRectangle = new DebugRectangle(d, d2, d3, d4);
        if (debugRectangleType == DebugRectangleType.CELL) {
            debugRectangle.setStroke((Paint)Color.RED);
            debugRectangle.getStrokeDashArray().addAll((Object[])new Double[]{3.0, 3.0});
        } else if (debugRectangleType == DebugRectangleType.EXTERNAL) {
            debugRectangle.setStroke((Paint)Color.ORANGE);
            debugRectangle.getStrokeDashArray().addAll((Object[])new Double[]{6.0, 6.0});
        } else if (debugRectangleType == DebugRectangleType.OUTLINE || debugRectangleType == DebugRectangleType.CONTAINER_OUTLINE) {
            debugRectangle.setStroke((Paint)Color.GREEN);
            debugRectangle.getStrokeDashArray().addAll((Object[])new Double[]{4.0, 4.0});
        } else {
            throw new IllegalStateException("Unknown debug rectangle type");
        }
        debugRectangle.setFill(null);
        this.getChildren().add((Object)debugRectangle);
        this.debugRectangles.add(debugRectangle);
    }

    protected double computeMaxHeight(double d) {
        int n = LayoutUtil.getSizeSafe((int[])(this.grid != null ? this.grid.getHeight() : null), (int)2);
        return n;
    }

    protected double computeMaxWidth(double d) {
        int n = LayoutUtil.getSizeSafe((int[])(this.grid != null ? this.grid.getWidth() : null), (int)2);
        return n;
    }

    protected double computeMinHeight(double d) {
        int n = LayoutUtil.getSizeSafe((int[])(this.grid != null ? this.grid.getHeight() : null), (int)0);
        return n;
    }

    protected double computeMinWidth(double d) {
        int n = LayoutUtil.getSizeSafe((int[])(this.grid != null ? this.grid.getWidth() : null), (int)0);
        return n;
    }

    protected double computePrefHeight(double d) {
        int n = LayoutUtil.getSizeSafe((int[])(this.grid != null ? this.grid.getHeight() : null), (int)1);
        return n;
    }

    protected double computePrefWidth(double d) {
        int n = LayoutUtil.getSizeSafe((int[])(this.grid != null ? this.grid.getWidth() : null), (int)1);
        return n;
    }

    class FX2ComponentWrapper
    implements ComponentWrapper {
        protected final Node node;

        public FX2ComponentWrapper(Node node) {
            this.node = node;
        }

        public Object getComponent() {
            return this.node;
        }

        public ContainerWrapper getParent() {
            return MigPane.this.fx2ContainerWrapper;
        }

        public int getComponetType(boolean bl) {
            if (this.node instanceof TextField || this.node instanceof TextArea) {
                return 3;
            }
            if (this.node instanceof Group) {
                return 1;
            }
            return 0;
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            this.node.resizeRelocate((double)n, (double)n2, (double)n3, (double)n4);
        }

        public int getX() {
            int n = (int)Math.ceil(this.node.getLayoutBounds().getMinX());
            return n;
        }

        public int getY() {
            int n = (int)Math.ceil(this.node.getLayoutBounds().getMinY());
            return n;
        }

        public int getWidth() {
            int n = (int)Math.ceil(this.node.getLayoutBounds().getWidth());
            return n;
        }

        public int getMinimumWidth(int n) {
            int n2 = (int)Math.ceil(this.node.minWidth((double)n));
            return n2;
        }

        public int getPreferredWidth(int n) {
            int n2 = (int)Math.ceil(this.node.prefWidth((double)n));
            return n2;
        }

        public int getMaximumWidth(int n) {
            int n2 = (int)Math.ceil(this.node.maxWidth((double)n));
            if (this.node instanceof Button) {
                n2 = Integer.MAX_VALUE;
            }
            if (this.node instanceof ToggleButton) {
                n2 = Integer.MAX_VALUE;
            }
            if (this.node instanceof CheckBox) {
                n2 = Integer.MAX_VALUE;
            }
            if (this.node instanceof ChoiceBox) {
                n2 = Integer.MAX_VALUE;
            }
            return n2;
        }

        public int getHeight() {
            int n = (int)Math.ceil(this.node.getLayoutBounds().getHeight());
            return n;
        }

        public int getMinimumHeight(int n) {
            int n2 = (int)Math.ceil(this.node.minHeight((double)n));
            return n2;
        }

        public int getPreferredHeight(int n) {
            int n2 = (int)Math.ceil(this.node.prefHeight((double)n));
            return n2;
        }

        public int getMaximumHeight(int n) {
            int n2 = (int)Math.ceil(this.node.maxHeight((double)n));
            return n2;
        }

        public int getBaseline(int n, int n2) {
            return -1;
        }

        public int getScreenLocationX() {
            Bounds bounds = this.node.localToScene(this.node.getBoundsInLocal());
            int n = (int)Math.ceil(this.node.getScene().getX() + this.node.getScene().getX() + bounds.getMinX());
            return n;
        }

        public int getScreenLocationY() {
            Bounds bounds = this.node.localToScene(this.node.getBoundsInLocal());
            int n = (int)Math.ceil(this.node.getScene().getY() + this.node.getScene().getY() + bounds.getMinY());
            return n;
        }

        public int getScreenHeight() {
            int n = (int)Math.ceil(Screen.getPrimary().getBounds().getHeight());
            return n;
        }

        public int getScreenWidth() {
            int n = (int)Math.ceil(Screen.getPrimary().getBounds().getWidth());
            return n;
        }

        public int[] getVisualPadding() {
            return null;
        }

        public int getHorizontalScreenDPI() {
            return (int)Math.ceil(Screen.getPrimary().getDpi());
        }

        public int getVerticalScreenDPI() {
            return (int)Math.ceil(Screen.getPrimary().getDpi());
        }

        public float getPixelUnitFactor(boolean bl) {
            return 1.0f;
        }

        public int getLayoutHashCode() {
            int n = 0;
            n += (int)this.node.getLayoutBounds().getWidth() + (int)this.node.getLayoutBounds().getHeight() * 32;
            if (this.node.isVisible()) {
                n += 1324511;
            }
            if (this.node.isManaged()) {
                n += 1324513;
            }
            if (this.node.getId().length() > 0) {
                n += this.node.getId().hashCode();
            }
            return 0;
        }

        public String getLinkId() {
            return this.node.getId();
        }

        public boolean hasBaseline() {
            return false;
        }

        public boolean isVisible() {
            return this.node.isVisible();
        }

        public void paintDebugOutline() {
            ComponentWrapper componentWrapper = (ComponentWrapper)MigPane.this.nodeToComponentWrapperMap.get(this.node);
            CC cC = (CC)MigPane.this.fx2ComponentWrapperToCCMap.get(componentWrapper);
            if (cC != null && cC.isExternal()) {
                MigPane.this.addDebugRectangle(this.node.getLayoutX() + this.node.getLayoutBounds().getMinX(), this.node.getLayoutY() + this.node.getLayoutBounds().getMinY(), this.getWidth(), this.getHeight(), DebugRectangleType.EXTERNAL);
            } else {
                MigPane.this.addDebugRectangle(this.node.getLayoutX() + this.node.getLayoutBounds().getMinX(), this.node.getLayoutY() + this.node.getLayoutBounds().getMinY(), this.getWidth(), this.getHeight(), DebugRectangleType.OUTLINE);
            }
        }

        public int hashCode() {
            return this.node.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof FX2ComponentWrapper)) {
                return false;
            }
            return this.getComponent().equals(((FX2ComponentWrapper)object).getComponent());
        }
    }

    class FX2ContainerWrapper
    extends FX2ComponentWrapper
    implements ContainerWrapper {
        public FX2ContainerWrapper(Node node) {
            super(node);
        }

        public ComponentWrapper[] getComponents() {
            return MigPane.this.componentWrapperList.toArray(new FX2ComponentWrapper[0]);
        }

        public int getComponentCount() {
            return MigPane.this.fx2ComponentWrapperToCCMap.size();
        }

        public Object getLayout() {
            return MigPane.this;
        }

        public boolean isLeftToRight() {
            return true;
        }

        public void paintDebugCell(int n, int n2, int n3, int n4) {
            MigPane.this.addDebugRectangle(n, n2, n3, n4, DebugRectangleType.CELL);
        }

        public void paintDebugOutline() {
            Bounds bounds = this.node.getBoundsInParent();
            Bounds bounds2 = this.node.getLayoutBounds();
            double d = bounds.getMinX() + (bounds.getMaxX() - bounds2.getMaxX());
            double d2 = bounds.getMinY() + (bounds.getMaxY() - bounds2.getMaxY());
            MigPane.this.addDebugRectangle(this.node.getLayoutX() + bounds2.getMinX() - d, this.node.getLayoutY() + bounds2.getMinY() - d2, (double)this.getWidth() + d, (double)this.getHeight() + d2, DebugRectangleType.CONTAINER_OUTLINE);
        }
    }

    class DebugRectangle
    extends Rectangle {
        public DebugRectangle(double d, double d2, double d3, double d4) {
            super(d, d2, d3, d4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DebugRectangleType {
        CELL,
        OUTLINE,
        CONTAINER_OUTLINE,
        EXTERNAL;

    }
}

