/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.identitygovernance.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.identitygovernance.models.WorkflowTemplate;
import com.microsoft.graph.identitygovernance.requests.WorkflowTemplateCollectionPage;
import com.microsoft.graph.identitygovernance.requests.WorkflowTemplateCollectionRequestBuilder;
import com.microsoft.graph.identitygovernance.requests.WorkflowTemplateCollectionResponse;
import com.microsoft.graph.identitygovernance.requests.WorkflowTemplateRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WorkflowTemplateCollectionRequest
extends BaseEntityCollectionRequest<WorkflowTemplate, WorkflowTemplateCollectionResponse, WorkflowTemplateCollectionPage> {
    public WorkflowTemplateCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkflowTemplateCollectionResponse.class, WorkflowTemplateCollectionPage.class, WorkflowTemplateCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<WorkflowTemplate> postAsync(@Nonnull WorkflowTemplate newWorkflowTemplate) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WorkflowTemplateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newWorkflowTemplate);
    }

    @Nonnull
    public WorkflowTemplate post(@Nonnull WorkflowTemplate newWorkflowTemplate) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WorkflowTemplateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWorkflowTemplate);
    }

    @Nonnull
    public WorkflowTemplateCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public WorkflowTemplateCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public WorkflowTemplateCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public WorkflowTemplateCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public WorkflowTemplateCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public WorkflowTemplateCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public WorkflowTemplateCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public WorkflowTemplateCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public WorkflowTemplateCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

