/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.resource;

import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Deletable;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.resource.GenericResource;
import com.microsoft.azure.toolkit.lib.resource.GenericResourceModule;
import com.microsoft.azure.toolkit.lib.resource.ResourceDeploymentModule;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupModule;
import com.microsoft.azure.toolkit.lib.resource.ResourcesServiceSubscription;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ResourceGroup
extends AbstractAzResource<ResourceGroup, ResourcesServiceSubscription, com.azure.resourcemanager.resources.models.ResourceGroup>
implements Deletable {
    private final ResourceDeploymentModule deploymentModule;
    private final GenericResourceModule resourceModule;

    protected ResourceGroup(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull ResourceGroupModule module) {
        super(name, resourceGroupName, module);
        this.deploymentModule = new ResourceDeploymentModule(this);
        this.resourceModule = new GenericResourceModule(this);
    }

    protected ResourceGroup(@Nonnull ResourceGroup origin) {
        super(origin);
        this.deploymentModule = origin.deploymentModule;
        this.resourceModule = origin.resourceModule;
    }

    protected ResourceGroup(@Nonnull com.azure.resourcemanager.resources.models.ResourceGroup remote, @Nonnull ResourceGroupModule module) {
        super(remote.name(), remote.name(), module);
        this.deploymentModule = new ResourceDeploymentModule(this);
        this.resourceModule = new GenericResourceModule(this);
    }

    @Override
    @Nonnull
    protected com.azure.resourcemanager.resources.models.ResourceGroup refreshRemoteFromAzure(@Nonnull com.azure.resourcemanager.resources.models.ResourceGroup remote) {
        ResourceManager manager = Objects.requireNonNull((ResourceManager)((ResourcesServiceSubscription)this.getParent()).getRemote(new boolean[0]));
        return (com.azure.resourcemanager.resources.models.ResourceGroup)manager.resourceGroups().getByName(this.getName());
    }

    @Override
    public void delete() {
        List<AbstractAzResource> localResources = this.genericResources().listCachedResources().stream().map(GenericResource::toConcreteResource).filter(r -> !(r instanceof GenericResource)).collect(Collectors.toList());
        localResources.forEach(r -> r.setStatus("Deleting"));
        try {
            super.delete();
        }
        catch (Throwable e) {
            localResources.forEach(r -> r.setStatus("Unknown"));
            throw new AzureToolkitRuntimeException(e);
        }
        localResources.parallelStream().forEach(AbstractAzResource::delete);
    }

    @Override
    @Nonnull
    public List<AbstractAzResourceModule<?, ResourceGroup, ?>> getSubModules() {
        return Arrays.asList(this.deploymentModule, this.resourceModule);
    }

    public ResourceDeploymentModule deployments() {
        return this.deploymentModule;
    }

    public GenericResourceModule genericResources() {
        return this.resourceModule;
    }

    @Override
    @Nonnull
    public String loadStatus(@Nonnull com.azure.resourcemanager.resources.models.ResourceGroup remote) {
        return remote.provisioningState();
    }

    @Nullable
    public Region getRegion() {
        return this.remoteOptional(new boolean[0]).map(remote -> Region.fromName(remote.regionName())).orElse(null);
    }

    @Nullable
    public String getType() {
        return this.remoteOptional(new boolean[0]).map(Resource::type).orElse(null);
    }
}

