/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.event;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.microsoft.azure.toolkit.lib.common.event.AzureEvent;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NonNls;
import reactor.core.scheduler.Schedulers;

public class AzureEventBus {
    @NonNls
    private static final Map<String, EventBus> buses = new ConcurrentHashMap<String, EventBus>();

    public static void on(@Nonnull String type, @Nonnull EventListener listener) {
        AzureEventBus.getBus(type).register((Object)listener);
    }

    public static void off(@Nonnull String type, @Nonnull EventListener listener) {
        AzureEventBus.getBus(type).unregister((Object)listener);
    }

    public static void once(@Nonnull String type, @Nonnull BiConsumer<Object, Object> listener) {
        EventListener[] listeners;
        EventBus bus = AzureEventBus.getBus(type);
        listeners = new EventListener[]{new EventListener(e -> {
            listener.accept(e.getSource(), e.getPayload());
            bus.unregister((Object)listeners[0]);
        })};
        bus.register((Object)listeners[0]);
    }

    public static void emit(@Nonnull String type) {
        AzureEventBus.emit(type, new SimpleEvent(type, null));
    }

    public static void emit(@Nonnull String type, @Nullable Object source) {
        AzureEventBus.emit(type, new SimpleEvent(type, source));
    }

    public static <T> void emit(@Nonnull String type, @Nonnull AzureEvent event) {
        AzureEventBus.getBus(type).post((Object)event);
    }

    private static EventBus getBus(String eventType) {
        return buses.computeIfAbsent(eventType, e -> new AsyncEventBus(command -> Schedulers.boundedElastic().schedule(command)));
    }

    private static class SimpleEvent
    implements AzureEvent {
        @Nonnull
        private final String type;
        @Nullable
        private final Object source;
        @Nullable
        private Object payload;

        @Override
        @Nonnull
        public String getType() {
            return this.type;
        }

        @Override
        @Nullable
        public Object getSource() {
            return this.source;
        }

        @Override
        @Nullable
        public Object getPayload() {
            return this.payload;
        }

        public SimpleEvent(@Nonnull String type, @Nullable Object source) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            this.source = source;
        }

        public SimpleEvent(@Nonnull String type, @Nullable Object source, @Nullable Object payload) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            this.source = source;
            this.payload = payload;
        }
    }

    public static class EventListener {
        @Nonnull
        private final Consumer<AzureEvent> listener;

        @Subscribe
        public void onEvent(@Nonnull AzureEvent event) {
            this.listener.accept(event);
        }

        public EventListener(@Nonnull Consumer<AzureEvent> listener) {
            if (listener == null) {
                throw new NullPointerException("listener is marked non-null but is null");
            }
            this.listener = listener;
        }
    }
}

