/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloundfoundry.environment;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.spring.cloundfoundry.environment.VcapPojo;
import com.microsoft.azure.spring.cloundfoundry.environment.VcapResult;
import com.microsoft.azure.spring.cloundfoundry.environment.VcapServiceConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Service;

@Service
@Configuration
public class VcapProcessor
implements EnvironmentPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(VcapProcessor.class);
    public static final String VCAP_SERVICES = "VCAP_SERVICES";
    public static final String LOG_VARIABLE = "COM_MICROSOFT_AZURE_CLOUDFOUNDRY_SERVICE_LOG";
    private static final String AZURE = "azure-";
    private static final String USER_PROVIDED = "user-provided";
    private static final String AZURE_SERVICE_BROKER_NAME = "azure-service-broker-name";
    private static final String AZURE_SERVICE_PLAN = "azure-service-plan";
    private static final String CREDENTIALS = "credentials";
    private boolean logFlag = false;

    public void postProcessEnvironment(ConfigurableEnvironment confEnv, SpringApplication app) {
        Map environment = confEnv.getSystemEnvironment();
        String logValue = (String)environment.get(LOG_VARIABLE);
        if ("true".equals(logValue)) {
            this.logFlag = true;
        }
        this.log("VcapParser.postProcessEnvironment: Start");
        String vcapServices = (String)environment.get(VCAP_SERVICES);
        VcapResult result = this.parse(vcapServices);
        result.setLogFlag(this.logFlag);
        result.setConfEnv(confEnv);
        result.populateProperties();
        this.log("VcapParser.postProcessEnvironment: End");
    }

    public VcapResult parse(String vcapServices) {
        VcapResult result = new VcapResult();
        ArrayList results = new ArrayList();
        this.log("VcapParser.parse:  vcapServices = " + vcapServices);
        if (vcapServices != null) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, false);
                Map servicesMap = (Map)objectMapper.readValue(vcapServices, (TypeReference)new TypeReference<Map<String, List<VcapServiceConfig>>>(){});
                Set services = servicesMap.entrySet();
                if (services != null) {
                    for (Map.Entry serviceEntry : services) {
                        String name = (String)serviceEntry.getKey();
                        if (!name.startsWith(AZURE) && !USER_PROVIDED.equals(name)) continue;
                        List azureServices = (List)serviceEntry.getValue();
                        results.addAll(azureServices.stream().map(service -> this.parseService(name, (VcapServiceConfig)service, vcapServices)).filter(vcapPojo -> vcapPojo != null).collect(Collectors.toList()));
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Error parsing " + vcapServices, (Throwable)e);
            }
        }
        result.setPojos(results.toArray(new VcapPojo[results.size()]));
        return result;
    }

    private VcapPojo parseService(String serviceBrokerName, VcapServiceConfig serviceConfig, String vCapServices) {
        VcapPojo result = new VcapPojo();
        Map<String, String> credentials = serviceConfig.getCredentials();
        if (USER_PROVIDED.equals(serviceBrokerName)) {
            if (credentials == null) {
                return null;
            }
            String userServiceBrokerName = credentials.remove(AZURE_SERVICE_BROKER_NAME);
            if (userServiceBrokerName == null) {
                return null;
            }
            result.setServiceBrokerName(userServiceBrokerName);
            String userServicePlan = credentials.remove(AZURE_SERVICE_PLAN);
            serviceConfig.setPlan(userServicePlan);
            serviceConfig.setCredentials(credentials);
        } else {
            result.setServiceBrokerName(serviceBrokerName);
            serviceConfig.setPlan(serviceConfig.getPlan());
            if (credentials == null) {
                LOGGER.error("Found " + serviceBrokerName + ", but missing " + CREDENTIALS + " : " + vCapServices);
            }
        }
        result.setServiceConfig(serviceConfig);
        return result;
    }

    private void log(String msg) {
        if (this.logFlag) {
            LOGGER.info(msg);
        }
    }
}

