/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.telemetry;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.azure.spring.support.GetHashMac;
import com.microsoft.azure.utils.PropertyLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class TelemetryProxy {
    private static final String PROJECT_INFO = "spring-boot-starter/" + PropertyLoader.getProjectVersion();
    protected TelemetryClient client = new TelemetryClient();
    private boolean isAllowTelemetry;

    public TelemetryProxy(boolean isAllowTelemetry) {
        this.isAllowTelemetry = isAllowTelemetry;
    }

    public void trackEvent(String eventName) {
        this.trackEvent(eventName, null, false);
    }

    public void trackEvent(String eventName, Map<String, String> customProperties) {
        this.trackEvent(eventName, customProperties, false);
    }

    public void trackEvent(String eventName, Map<String, String> customProperties, boolean overrideDefaultProperties) {
        Map<String, String> properties = this.getDefaultProperties();
        if (this.isAllowTelemetry) {
            properties = this.mergeProperties(this.getDefaultProperties(), customProperties, overrideDefaultProperties);
        }
        this.client.trackEvent(eventName, properties, null);
        this.client.flush();
    }

    protected Map<String, String> mergeProperties(Map<String, String> defaultProperties, Map<String, String> customProperties, boolean overrideDefaultProperties) {
        if (customProperties == null) {
            return defaultProperties;
        }
        HashMap<String, String> merged = new HashMap<String, String>();
        if (overrideDefaultProperties) {
            merged.putAll(defaultProperties);
            merged.putAll(customProperties);
        } else {
            merged.putAll(customProperties);
            merged.putAll(defaultProperties);
        }
        Iterator it = merged.entrySet().iterator();
        while (it.hasNext()) {
            if (!StringUtils.isEmpty((CharSequence)((CharSequence)it.next().getValue()))) continue;
            it.remove();
        }
        return merged;
    }

    public Map<String, String> getDefaultProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (this.isAllowTelemetry) {
            properties.put("installationId", GetHashMac.getHashMac());
            properties.put("version", PROJECT_INFO);
        } else {
            properties.put("telemetryNotAllowed", "true");
        }
        return properties;
    }
}

