/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.spring;

import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.keyvault.KeyVaultClient;
import com.microsoft.azure.keyvault.spring.AzureKeyVaultCredential;
import com.microsoft.azure.keyvault.spring.Constants;
import com.microsoft.azure.keyvault.spring.KeyVaultOperation;
import com.microsoft.azure.keyvault.spring.KeyVaultPropertySource;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.azure.spring.support.UserAgent;
import com.microsoft.azure.telemetry.TelemetryProxy;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import java.util.HashMap;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class KeyVaultEnvironmentPostProcessorHelper {
    private final ConfigurableEnvironment environment;
    private final TelemetryProxy telemetryProxy;

    public KeyVaultEnvironmentPostProcessorHelper(ConfigurableEnvironment environment) {
        this.environment = environment;
        this.telemetryProxy = new TelemetryProxy(this.allowTelemetry(environment));
    }

    public void addKeyVaultPropertySource() {
        String clientId = this.getProperty(this.environment, "azure.keyvault.client-id");
        String clientKey = this.getProperty(this.environment, "azure.keyvault.client-key");
        String vaultUri = this.getProperty(this.environment, "azure.keyvault.uri");
        long timeAcquiringTimeoutInSeconds = (Long)this.environment.getProperty("azure.keyvault.token-acquire-timeout-seconds", Long.class, (Object)60L);
        AzureKeyVaultCredential credentials = new AzureKeyVaultCredential(clientId, clientKey, timeAcquiringTimeoutInSeconds);
        RestClient restClient = new RestClient.Builder().withBaseUrl(vaultUri).withCredentials((ServiceClientCredentials)credentials).withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory()).withUserAgent(UserAgent.getUserAgent(Constants.AZURE_KEYVAULT_USER_AGENT, this.allowTelemetry(this.environment))).build();
        KeyVaultClient kvClient = new KeyVaultClient(restClient);
        this.trackCustomEvent();
        try {
            MutablePropertySources sources = this.environment.getPropertySources();
            KeyVaultOperation kvOperation = new KeyVaultOperation(kvClient, vaultUri);
            if (sources.contains("systemEnvironment")) {
                sources.addAfter("systemEnvironment", (PropertySource)new KeyVaultPropertySource(kvOperation));
            } else {
                sources.addFirst((PropertySource)new KeyVaultPropertySource(kvOperation));
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to configure KeyVault property source", ex);
        }
    }

    private String getProperty(ConfigurableEnvironment env, String propertyName) {
        Assert.notNull((Object)env, (String)"env must not be null!");
        Assert.notNull((Object)propertyName, (String)"propertyName must not be null!");
        String property = env.getProperty(propertyName);
        if (property == null || property.isEmpty()) {
            throw new IllegalArgumentException("property " + propertyName + " must not be null");
        }
        return property;
    }

    private boolean allowTelemetry(ConfigurableEnvironment env) {
        Assert.notNull((Object)env, (String)"env must not be null!");
        return (Boolean)env.getProperty("azure.keyvault.allow.telemetry", Boolean.class, (Object)true);
    }

    private void trackCustomEvent() {
        HashMap<String, String> customTelemetryProperties = new HashMap<String, String>();
        customTelemetryProperties.put("serviceName", "keyvault");
        this.telemetryProxy.trackEvent(ClassUtils.getUserClass(this.getClass()).getSimpleName(), customTelemetryProperties);
    }
}

