/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.amqp;

import com.microsoft.azure.servicebus.amqp.BaseLinkHandler;
import com.microsoft.azure.servicebus.amqp.IAmqpReceiver;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReceiveLinkHandler
extends BaseLinkHandler {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(ReceiveLinkHandler.class);
    private final IAmqpReceiver amqpReceiver;
    private final Object firstResponse;
    private boolean isFirstResponse;

    public ReceiveLinkHandler(IAmqpReceiver receiver) {
        super(receiver);
        this.amqpReceiver = receiver;
        this.firstResponse = new Object();
        this.isFirstResponse = true;
    }

    public void onLinkLocalOpen(Event evt) {
        Link link = evt.getLink();
        if (link instanceof Receiver) {
            Receiver receiver = (Receiver)link;
            TRACE_LOGGER.debug("onLinkLocalOpen: linkName:{}, localSource:{}", (Object)receiver.getName(), (Object)receiver.getSource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLinkRemoteOpen(Event event) {
        Link link = event.getLink();
        if (link != null && link instanceof Receiver) {
            Receiver receiver = (Receiver)link;
            if (link.getRemoteSource() != null) {
                TRACE_LOGGER.debug("onLinkRemoteOpen: linkName:{}, remoteSource:{}", (Object)receiver.getName(), (Object)receiver.getRemoteSource());
                Object object = this.firstResponse;
                synchronized (object) {
                    this.isFirstResponse = false;
                    this.amqpReceiver.onOpenComplete(null);
                }
            } else {
                TRACE_LOGGER.debug("onLinkRemoteOpen: linkName:{}, remoteTarget:{}, remoteTarget:{}, action:{}", new Object[]{receiver.getName(), null, null, "waitingForError"});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDelivery(Event event) {
        Object object = this.firstResponse;
        synchronized (object) {
            if (this.isFirstResponse) {
                this.isFirstResponse = false;
                this.amqpReceiver.onOpenComplete(null);
            }
        }
        Delivery delivery = event.getDelivery();
        Receiver receiveLink = (Receiver)delivery.getLink();
        TRACE_LOGGER.debug("onDelivery: linkName:{}, updatedLinkCredit:{}, remoteCredit:{}, remoteCondition:{}, delivery.isPartial:{}", new Object[]{receiveLink.getName(), receiveLink.getCredit(), receiveLink.getRemoteCredit(), receiveLink.getRemoteCondition(), delivery.isPartial()});
        if (!delivery.isPartial()) {
            this.amqpReceiver.onReceiveComplete(delivery);
        }
    }
}

