/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.dependencies.http.impl.nio.reactor;

import com.microsoft.applicationinsights.web.dependencies.http.annotation.Contract;
import com.microsoft.applicationinsights.web.dependencies.http.annotation.ThreadingBehavior;
import java.util.Date;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ExceptionEvent {
    private final Throwable ex;
    private final long time;

    public ExceptionEvent(Throwable ex, Date timestamp) {
        this.ex = ex;
        this.time = timestamp != null ? timestamp.getTime() : 0L;
    }

    public ExceptionEvent(Exception ex) {
        this(ex, new Date());
    }

    public Throwable getCause() {
        return this.ex;
    }

    public Date getTimestamp() {
        return new Date(this.time);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(new Date(this.time));
        buffer.append(" ");
        buffer.append(this.ex);
        return buffer.toString();
    }
}

