/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.simplehttp;

import com.microsoft.applicationinsights.channel.TelemetryChannel;
import com.microsoft.applicationinsights.channel.TelemetrySampler;
import com.microsoft.applicationinsights.core.dependencies.http.HttpEntity;
import com.microsoft.applicationinsights.core.dependencies.http.client.methods.CloseableHttpResponse;
import com.microsoft.applicationinsights.core.dependencies.http.client.methods.HttpPost;
import com.microsoft.applicationinsights.core.dependencies.http.entity.ContentType;
import com.microsoft.applicationinsights.core.dependencies.http.entity.StringEntity;
import com.microsoft.applicationinsights.core.dependencies.http.impl.client.CloseableHttpClient;
import com.microsoft.applicationinsights.core.dependencies.http.impl.client.HttpClients;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.telemetry.JsonTelemetryDataSerializer;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import java.util.concurrent.TimeUnit;

final class SimpleHttpChannel
implements TelemetryChannel {
    private static final String DEFAULT_SERVER_URI = "https://dc.services.visualstudio.com/v2/track";
    private boolean developerMode = false;

    @Override
    public boolean isDeveloperMode() {
        return this.developerMode;
    }

    @Override
    public void setDeveloperMode(boolean value) {
        this.developerMode = value;
    }

    public SimpleHttpChannel(Map<String, String> namesAndValues) {
    }

    @Override
    public void send(Telemetry item) {
        try {
            StringWriter writer = new StringWriter();
            item.serialize(new JsonTelemetryDataSerializer(writer));
            String payload = writer.toString();
            if (this.developerMode) {
                InternalLogger.INSTANCE.trace("SimpleHttpChannel, payload: %s", payload);
            }
            HttpPost request = new HttpPost(DEFAULT_SERVER_URI);
            StringEntity body = new StringEntity(payload, ContentType.create("application/x-json-stream"));
            request.setEntity(body);
            try (CloseableHttpClient httpClient = HttpClients.createDefault();
                 CloseableHttpResponse response = httpClient.execute(request);){
                HttpEntity respEntity = response.getEntity();
                if (respEntity != null) {
                    respEntity.getContent().close();
                }
                if (this.developerMode) {
                    InternalLogger.INSTANCE.trace("SimpleHttpChannel, response: %s", response.getStatusLine());
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void stop(long timeout, TimeUnit timeUnit) {
    }

    @Override
    public void flush() {
    }

    @Override
    public void setSampler(TelemetrySampler telemetrySampler) {
    }
}

