/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.resourcepool;

import com.mchange.v2.resourcepool.ResourcePool;
import com.mchange.v2.resourcepool.ResourcePoolEvent;
import com.mchange.v2.resourcepool.ResourcePoolListener;
import java.util.HashSet;
import java.util.Set;

public class ResourcePoolEventSupport {
    ResourcePool source;
    Set mlisteners = new HashSet();

    public ResourcePoolEventSupport(ResourcePool resourcePool) {
        this.source = resourcePool;
    }

    public synchronized void addResourcePoolListener(ResourcePoolListener resourcePoolListener) {
        this.mlisteners.add(resourcePoolListener);
    }

    public synchronized void removeResourcePoolListener(ResourcePoolListener resourcePoolListener) {
        this.mlisteners.remove(resourcePoolListener);
    }

    public synchronized void fireResourceAcquired(Object object, int n, int n2, int n3) {
        if (!this.mlisteners.isEmpty()) {
            ResourcePoolEvent resourcePoolEvent = new ResourcePoolEvent(this.source, object, false, n, n2, n3);
            for (ResourcePoolListener resourcePoolListener : this.mlisteners) {
                resourcePoolListener.resourceAcquired(resourcePoolEvent);
            }
        }
    }

    public synchronized void fireResourceCheckedIn(Object object, int n, int n2, int n3) {
        if (!this.mlisteners.isEmpty()) {
            ResourcePoolEvent resourcePoolEvent = new ResourcePoolEvent(this.source, object, false, n, n2, n3);
            for (ResourcePoolListener resourcePoolListener : this.mlisteners) {
                resourcePoolListener.resourceCheckedIn(resourcePoolEvent);
            }
        }
    }

    public synchronized void fireResourceCheckedOut(Object object, int n, int n2, int n3) {
        if (!this.mlisteners.isEmpty()) {
            ResourcePoolEvent resourcePoolEvent = new ResourcePoolEvent(this.source, object, true, n, n2, n3);
            for (ResourcePoolListener resourcePoolListener : this.mlisteners) {
                resourcePoolListener.resourceCheckedOut(resourcePoolEvent);
            }
        }
    }

    public synchronized void fireResourceRemoved(Object object, boolean bl, int n, int n2, int n3) {
        if (!this.mlisteners.isEmpty()) {
            ResourcePoolEvent resourcePoolEvent = new ResourcePoolEvent(this.source, object, bl, n, n2, n3);
            for (ResourcePoolListener resourcePoolListener : this.mlisteners) {
                resourcePoolListener.resourceRemoved(resourcePoolEvent);
            }
        }
    }
}

