/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.springmvc.controller;

import com.mangofactory.swagger.ControllerDocumentation;
import com.mangofactory.swagger.SwaggerConfiguration;
import com.mangofactory.swagger.springmvc.MvcApiReader;
import com.wordnik.swagger.core.Documentation;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.WebApplicationContext;

@Controller
@RequestMapping(value={"/apidoc"})
public class DocumentationController
implements InitializingBean {
    private static final String CONTROLLER_ENDPOINT = "apidoc";
    private String apiVersion = "1.0";
    private String swaggerVersion = "1.0";
    private String basePath = "/";
    @Autowired
    private WebApplicationContext wac;
    private MvcApiReader apiReader;

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Documentation getResourceListing() {
        return this.apiReader.getResourceListing();
    }

    @RequestMapping(value={"/{apiName}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ControllerDocumentation getApiDocumentation(@PathVariable(value="apiName") String apiName) {
        return this.apiReader.getDocumentation(apiName);
    }

    public void afterPropertiesSet() throws Exception {
        String documentationBasePath = this.basePath;
        if (!this.basePath.endsWith("/")) {
            documentationBasePath = documentationBasePath + "/";
        }
        documentationBasePath = documentationBasePath + CONTROLLER_ENDPOINT;
        SwaggerConfiguration config = new SwaggerConfiguration(this.apiVersion, this.swaggerVersion, documentationBasePath);
        this.apiReader = new MvcApiReader(this.wac, config);
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getSwaggerVersion() {
        return this.swaggerVersion;
    }

    public void setSwaggerVersion(String swaggerVersion) {
        this.swaggerVersion = swaggerVersion;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public MvcApiReader getApiReader() {
        return this.apiReader;
    }
}

